/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import reborncore.client.gui.Theme;
import reborncore.client.gui.ThemeManager;
import techreborn.config.TechRebornConfig;
import techreborn.packets.serverbound.RefundPayload;

public class GuiManual extends class_437 {

	private static final class_2960 MANUAL_TEXTURE = class_2960.method_60655("techreborn", "textures/gui/manual.png");
	final int guiWidth = 207;
	final int guiHeight = 195;
	private static final class_2561 text1 = class_2561.method_43471("techreborn.manual.wiki");
	private static final class_2561 text2 = class_2561.method_43471("techreborn.manual.discord");
	private static final class_2561 text3 = class_2561.method_43471("techreborn.manual.refund");

	private final Theme theme;

	public GuiManual() {
		super(class_2561.method_43470("gui.manual"));
		this.theme = ThemeManager.getTheme();
	}

	@Override
	public void method_25426() {
		super.method_25426();
		int y = (field_22790 / 2) - guiHeight / 2;

		method_37063(
			class_4185.method_46430(class_2561.method_43471("techreborn.manual.wikibtn"), button -> {
				openLink("https://wiki.techreborn.ovh");
			}).method_46434((field_22789 / 2 - 30), y + 60, 60, 20).method_46431()
		);

		method_37063(
			class_4185.method_46430(class_2561.method_43471("techreborn.manual.discordbtn"), button -> {
				openLink("https://discord.gg/teamreborn");
			}).method_46434((field_22789 / 2 - 30), y + 110, 60, 20).method_46431()
		);

		if (TechRebornConfig.allowManualRefund) {
			method_37063(
				class_4185.method_46430(class_2561.method_43471("techreborn.manual.refundbtn"), button -> {
					ClientPlayNetworking.send(new RefundPayload());
					field_22787.method_1507(null);
				}).method_46434((field_22789 / 2 - 30), y + 160, 60, 20).method_46431()
			);
		}
	}

	private void openLink(String url) {
		field_22787.method_1507(new class_407(t -> {
			if (t) {
				class_156.method_668().method_670(url);
			}
			this.field_22787.method_1507(this);
		}, url, false));
	}

	@Override
	public void method_25420(class_332 drawContext, int mouseX, int mouseY, float delta) {
		super.method_25420(drawContext, mouseX, mouseY, delta);
		int centerX = (field_22789 / 2) - guiWidth / 2;
		int centerY = (field_22790 / 2) - guiHeight / 2;
		drawContext.method_25290(class_10799.field_56883, MANUAL_TEXTURE, centerX, centerY, 0, 0, guiWidth, guiHeight, 256, 256);
	}

	@Override
	public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(drawContext, mouseX, mouseY, partialTicks);

		int centerY = (field_22790 / 2) - guiHeight / 2;

		drawContext.method_51439(field_22793, text1, (field_22789 / 2) - field_22793.method_27525(text1) / 2, centerY + 40, theme.titleColor().comp_1971(), false);
		drawContext.method_51439(field_22793, text2, (field_22789 / 2) - field_22793.method_27525(text2) / 2, centerY + 90, theme.titleColor().comp_1971(), false);
		if (TechRebornConfig.allowManualRefund) {
			drawContext.method_51439(field_22793, text3, (field_22789 / 2) - field_22793.method_27525(text3) / 2, centerY + 140, theme.titleColor().comp_1971(), false);
		}
	}
}
