/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_8666;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiBuilder;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.machine.iron.IronFurnaceBlockEntity;
import techreborn.packets.serverbound.ExperiencePayload;
import techreborn.utils.PlayerUtils;

import java.util.Objects;

public class GuiIronFurnace extends GuiBase<BuiltScreenHandler> {
	final IronFurnaceBlockEntity blockEntity;
	private static final class_2960 EXP_BUTTON_TEXTURE = class_2960.method_60656("item/experience_bottle");

	public GuiIronFurnace(int syncID, class_1657 player, IronFurnaceBlockEntity furnace) {
		super(player, furnace, furnace.createScreenHandler(syncID, player));
		this.blockEntity = furnace;
	}

	public void onClick(class_4185 buttonWidget) {
		ClientPlayNetworking.send(new ExperiencePayload(blockEntity.method_11016()));
	}

	@Override
	public void method_25426() {
		super.method_25426();
		method_37063(new XpButtonWidget(this::onClick));
	}

	private class XpButtonWidget extends class_344 {
		private static final class_8666 TEXTURES = new class_8666(EXP_BUTTON_TEXTURE, EXP_BUTTON_TEXTURE);

		public XpButtonWidget(class_4241 pressAction) {
			super(getGuiLeft() + 116,
				getGuiTop() + 58,
				16,
				16,
				TEXTURES,
				pressAction,
				class_2561.method_43473());
		}

		@Override
		public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
			super.method_48579(context, mouseX, mouseY, delta);

			if (field_22762) {
				context.method_51438(method_64506(), getTooltipText(), mouseX, mouseY);
			}
		}

		private class_2561 getTooltipText() {
			class_1657 player = class_310.method_1551().field_1724;
			Objects.requireNonNull(player);
			String message = ": ";

			float furnaceExp = blockEntity.experience;
			if (furnaceExp <= 0) {
				message = message + "0";
			} else {
				float expTillLevel = (1.0F - player.field_7510) * player.method_7349();
				if (furnaceExp <= expTillLevel) {
					int percentage = (int) (blockEntity.experience * 100 / player.method_7349());
					message = message + "+"
						+ (percentage > 0 ? String.valueOf(percentage) : "<1")
						+ "%";
				} else {
					int levels = 0;
					furnaceExp -= expTillLevel;
					while (furnaceExp > 0) {
						furnaceExp -= PlayerUtils.getLevelExperience(player.field_7520);
						++levels;
					}
					message = message + "+" + levels + "L";
				}
			}

			return class_2561.method_43471("techreborn.tooltip.experience")
				.method_27693(message);
		}
	}

	@Override
	protected void method_2389(class_332 drawContext, float lastFrameDuration, int mouseX, int mouseY) {
		super.method_2389(drawContext, lastFrameDuration, mouseX, mouseY);
		final GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;

		// Input slot
		drawSlot(drawContext, 56, 17, layer);
		// Fuel slot
		drawSlot(drawContext, 56, 53, layer);

		drawOutputSlot(drawContext, 116, 35, layer);
	}

	@Override
	protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
		super.method_2388(drawContext, mouseX, mouseY);
		final GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;

		builder.drawProgressBar(drawContext, this, blockEntity.getProgressScaled(100), 100, 85, 36, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
		builder.drawBurnBar(drawContext, this, blockEntity.getBurnTimeRemainingScaled(100), 100, 56, 36, mouseX, mouseY, layer);
	}
}
