/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import reborncore.client.gui.GuiBase;
import reborncore.client.gui.widget.GuiButtonExtended;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.machine.tier1.GreenhouseControllerBlockEntity;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class GuiGreenhouseController extends GuiBase<BuiltScreenHandler> {

	private final GreenhouseControllerBlockEntity blockEntity;

	public GuiGreenhouseController(int syncID, final class_1657 player, final GreenhouseControllerBlockEntity blockEntity) {
		super(player, blockEntity, blockEntity.createScreenHandler(syncID, player));
		this.blockEntity = blockEntity;
	}

	@Override
	protected void method_2389(class_332 drawContext, final float f, final int mouseX, final int mouseY) {
		super.method_2389(drawContext, f, mouseX, mouseY);
		final GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;

		drawSlot(drawContext, 8, 72, layer);

		int gridYPos = 22;
		drawSlot(drawContext, 30, gridYPos, layer);
		drawSlot(drawContext, 48, gridYPos, layer);
		drawSlot(drawContext, 30, gridYPos + 18, layer);
		drawSlot(drawContext, 48, gridYPos + 18, layer);
		drawSlot(drawContext, 30, gridYPos + 36, layer);
		drawSlot(drawContext, 48, gridYPos + 36, layer);

		if (!blockEntity.isShapeValid()) {
			drawContext.method_25290(class_10799.field_56883, class_2960.method_60655("techreborn", "textures/item/part/digital_display.png"), field_2776 + 68, field_2800 + 22, 0, 0, 16, 16, 16, 16);
			if (isPointInRect(68, 22, 16, 16, mouseX, mouseY)) {
				List<class_2561> list = Arrays.stream(class_1074.method_4662("techreborn.tooltip.greenhouse.upgrade_available")
						.split("\\r?\\n"))
						.map(class_2561::method_43470)
						.collect(Collectors.toList());

				drawContext.method_51434(method_64506(), list, mouseX, mouseY);
			}
		}

	}

	@Override
	protected void method_2388(class_332 drawContext, final int mouseX, final int mouseY) {
		super.method_2388(drawContext, mouseX, mouseY);
		final GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;

		addHologramButton(90, 24, 212, layer).clickHandler(this::onClick);
		builder.drawHologramButton(drawContext, this, 90, 24, mouseX, mouseY, layer);

		builder.drawMultiEnergyBar(drawContext, this, 9, 19, (int) blockEntity.getEnergy(), (int) blockEntity.getMaxStoredPower(), mouseX, mouseY, 0, layer);
	}

	public void onClick(GuiButtonExtended button, Double x, Double y) {
		blockEntity.renderMultiblock ^= !hideGuiElements();
	}
}
