/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import reborncore.client.ClientChunkManager;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.widget.GuiButtonUpDown;
import reborncore.client.gui.widget.GuiButtonUpDown.UpDownButtonType;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.machine.tier3.ChunkLoaderBlockEntity;
import techreborn.packets.serverbound.ChunkloaderPayload;

public class GuiChunkLoader extends GuiBase<BuiltScreenHandler> {

	final ChunkLoaderBlockEntity blockEntity;

	public GuiChunkLoader(int syncID, class_1657 player, ChunkLoaderBlockEntity blockEntity) {
		super(player, blockEntity, blockEntity.createScreenHandler(syncID, player));
		this.blockEntity = blockEntity;
	}

	public void method_25426() {
		super.method_25426();
		method_37063(new GuiButtonUpDown(field_2776 + 64, field_2800 + 40, this, b -> onClick(5), UpDownButtonType.FASTFORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 64 + 12, field_2800 + 40, this, b -> onClick(1), UpDownButtonType.FORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 64 + 24, field_2800 + 40, this, b -> onClick(-1), UpDownButtonType.REWIND));
		method_37063(new GuiButtonUpDown(field_2776 + 64 + 36, field_2800 + 40, this, b -> onClick(-5), UpDownButtonType.FASTREWIND));

		method_37063(
			class_4185.method_46430(getToogleText(ClientChunkManager.isShow()), button -> {
				button.method_25355(getToogleText(!ClientChunkManager.isShow()));
				ClientChunkManager.toggleLoadedChunks(blockEntity.method_11016());
			})
			.method_46433(field_2776 + 10, field_2800 + 70)
			.method_46437(155, 20)
			.method_46431()
		);
	}

	private class_2561 getToogleText(Boolean show) {
		if (show) {
			return class_2561.method_43471("gui.techreborn.chunk.hide_loaded_chunks");
		} else {
			return class_2561.method_43471("gui.techreborn.chunk.show_loaded_chunks");
		}
	}

	@Override
	protected void method_2389(class_332 drawContext, float partialTicks, int mouseX, int mouseY) {
		super.method_2389(drawContext, partialTicks, mouseX, mouseY);
		final Layer layer = Layer.BACKGROUND;

		if (hideGuiElements()) return;

		class_2561 text = class_2561.method_43471("gui.techreborn.chunk.radius")
				.method_27693(": ")
				.method_27693(String.valueOf(blockEntity.getRadius()));
		drawCentredText(drawContext, text, 25, theme.titleColor().comp_1971(), layer);
	}

	public void onClick(int amount) {
		ClientPlayNetworking.send(new ChunkloaderPayload(blockEntity.method_11016(), amount, ClientChunkManager.hasChunksForLoader(blockEntity.method_11016())));
	}
}
