/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.widget.GuiButtonUpDown;
import reborncore.client.gui.widget.GuiButtonUpDown.UpDownButtonType;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.storage.energy.AdjustableSUBlockEntity;
import techreborn.packets.serverbound.AESUConfigPayload;

public class GuiAESU extends GuiBase<BuiltScreenHandler> {

	final AdjustableSUBlockEntity blockEntity;

	public GuiAESU(int syncID, final class_1657 player, final AdjustableSUBlockEntity aesu) {
		super(player, aesu, aesu.createScreenHandler(syncID, player));
		this.blockEntity = aesu;
	}

	@Override
	public void method_25426() {
		super.method_25426();
		method_37063(new GuiButtonUpDown(field_2776 + 121, field_2800 + 79, this, b -> onClick(256), UpDownButtonType.FASTFORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 121 + 12, field_2800 + 79, this, b -> onClick(64), UpDownButtonType.FORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 121 + 24, field_2800 + 79, this, b -> onClick(-64), UpDownButtonType.REWIND));
		method_37063(new GuiButtonUpDown(field_2776 + 121 + 36, field_2800 + 79, this, b -> onClick(-256), UpDownButtonType.FASTREWIND));
	}

	@Override
	protected void method_2389(class_332 drawContext, final float f, final int mouseX, final int mouseY) {
		super.method_2389(drawContext, f, mouseX, mouseY);
		final Layer layer = Layer.BACKGROUND;

		this.drawSlot(drawContext, 62, 45, layer);
		this.drawSlot(drawContext, 98, 45, layer);
		this.drawArmourSlots(drawContext, 8, 18, layer);
		this.builder.drawEnergyOutput(drawContext, this, 155, 61, this.blockEntity.getCurrentOutput(), layer);
	}

	@Override
	protected void method_2388(class_332 drawContext, final int mouseX, final int mouseY) {
		super.method_2388(drawContext, mouseX, mouseY);
		final Layer layer = Layer.FOREGROUND;

		if (!hideGuiElements()) {
			final Matrix3x2fStack matrices = drawContext.method_51448();
			matrices.pushMatrix();
			matrices.scale(0.6f, 0.6f);
			class_2561 text = class_2561.method_43470(PowerSystem.getLocalizedPowerNoSuffix(blockEntity.getEnergy()))
					.method_27693("/")
					.method_27693(PowerSystem.getLocalizedPowerNoSuffix(blockEntity.getMaxStoredPower()))
					.method_27693(" ")
					.method_27693(PowerSystem.ABBREVIATION);

			drawCentredText(drawContext, text, 35, 0xff000000, 58, layer);
			matrices.popMatrix();
		}

		builder.drawMultiEnergyBar(drawContext, this, 81, 28, (int) blockEntity.getEnergy(), (int) blockEntity.getMaxStoredPower(), mouseX, mouseY, 0, layer);
	}

	public void onClick(int amount) {
		class_310 mc = class_310.method_1551();
		ClientPlayNetworking.send(new AESUConfigPayload(blockEntity.method_11016(), amount, mc.method_74187(), mc.method_74188()));
	}
}
