/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.events;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import reborncore.api.IListInfoProvider;
import reborncore.common.BaseBlockEntityProvider;
import techreborn.blocks.cable.CableBlock;
import techreborn.events.OreDepthSyncHandler;
import techreborn.init.TRContent;
import techreborn.items.DynamicCellItem;
import techreborn.items.UpgradeItem;
import techreborn.items.armor.NanoSuitItem;
import techreborn.items.armor.QuantumSuitItem;
import techreborn.world.OreDepth;
import techreborn.world.TargetDimension;

import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StackToolTipHandler implements ItemTooltipCallback {

	public static final Map<class_1792, Boolean> ITEM_ID = Maps.newHashMap();
	private static final List<class_2248> UNOBTAINABLE_ORES = Lists.newLinkedList();

	public static void setup() {
		ItemTooltipCallback.EVENT.register(new StackToolTipHandler());

		for (TRContent.Ores ore : TRContent.Ores.values()) {
			if (ore.isDeepslate()) {
				TRContent.Ores normal = ore.getUnDeepslate();
				if (normal.distribution != null && normal.distribution.dimension != TargetDimension.OVERWORLD)
					UNOBTAINABLE_ORES.add(ore.block);
			}
		}
	}

	@Override
	public void getTooltip(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 tooltipType, List<class_2561> lines) {
		class_1792 item = stack.method_7909();

		// Can currently be executed by a ForkJoinPool.commonPool-worker when REI is in async search mode
		// We skip this method until a thread-safe solution is in place
		class_310 mc = class_310.method_1551();
		if (!mc.method_18854())
			return;

		if (!ITEM_ID.computeIfAbsent(item, StackToolTipHandler::isTRItem))
			return;

		// Machine info and upgrades helper section
		class_2248 block = class_2248.method_9503(item);

		if (block instanceof BaseBlockEntityProvider) {
			ToolTipAssistUtils.addInfo(item.method_7876(), lines);
		}

		if (block instanceof CableBlock cable) {
			class_2586 blockEntity = cable.method_10123(class_2338.field_10980, block.method_9564());
			if (blockEntity != null) {
				((IListInfoProvider) blockEntity).addInfo(lines, false, false);
			}
		}

		if (item instanceof UpgradeItem upgrade) {
			ToolTipAssistUtils.addInfo(item.method_7876(), lines, false);
			lines.addAll(ToolTipAssistUtils.getUpgradeStats(TRContent.Upgrades.fromItem(upgrade), stack.method_7947(), mc.method_74187()));
		}

		if (item instanceof DynamicCellItem cell) {
			class_3611 fluid = cell.getFluid(stack);
			if (!(fluid instanceof class_3609) && fluid != class_3612.field_15906)
				ToolTipAssistUtils.addInfo("unplaceable_fluid", lines, false);
		}

		if (item == TRContent.Upgrades.SUPERCONDUCTOR.item && mc.method_74188()) {
			lines.add(class_2561.method_43470(class_124.field_1065 + "Blame obstinate_3 for this"));
		}

		if (item == TRContent.OMNI_TOOL) {
			lines.add(class_2561.method_43470(class_124.field_1054 + class_1074.method_4662("techreborn.tooltip.omnitool_motto")));
		}

		if (block == TRContent.Machine.INDUSTRIAL_CENTRIFUGE.block && mc.method_74188()) {
			lines.add(class_2561.method_43470("Round and round it goes"));
		}

		if (UNOBTAINABLE_ORES.contains(block)) {
			lines.add(class_2561.method_43471("techreborn.tooltip.unobtainable").method_27692(class_124.field_1075));
		} else if (OreDepthSyncHandler.getOreDepthMap().containsKey(block)) {
			OreDepth oreDepth = OreDepthSyncHandler.getOreDepthMap().get(block);
			class_2561 text = getOreDepthText(oreDepth);
			lines.add(text.method_27661().method_27692(class_124.field_1075));
		}

		if (item instanceof NanoSuitItem suit) {
			suit.appendArmorTooltip(stack, lines, mc.method_74187());
		} else if (item instanceof QuantumSuitItem suit) {
			suit.appendArmorTooltip(stack, lines, mc.method_74187());
		}
	}

	private static boolean isTRItem(class_1792 item) {
		return class_7923.field_41178.method_10221(item).method_12836().equals("techreborn");
	}

	private static class_2561 getOreDepthText(OreDepth depth) {
		return class_2561.method_43469("techreborn.tooltip.ores.%s".formatted(depth.dimension().name().toLowerCase(Locale.ROOT)),
				class_2561.method_43470(String.valueOf(depth.minY())).method_27692(class_124.field_1054),
				class_2561.method_43470(String.valueOf(depth.maxY())).method_27692(class_124.field_1054)
		);
	}
}
