/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.compat.rei.machine;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import reborncore.client.gui.GuiBuilder;
import techreborn.client.compat.rei.ReiPlugin;
import techreborn.compat.rei.RollingMachineDisplay;
import techreborn.recipe.recipes.RollingMachineRecipe;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class RollingMachineCategory implements DisplayCategory<RollingMachineDisplay> {

	private final class_3956<RollingMachineRecipe> recipeType;

	public RollingMachineCategory(class_3956<RollingMachineRecipe> recipeType) {
		this.recipeType = recipeType;
	}

	private class_2960 id() {
		return class_7923.field_41188.method_10221(recipeType);
	}


	@Override
	public CategoryIdentifier<? extends RollingMachineDisplay> getCategoryIdentifier() {
		return CategoryIdentifier.of(id());
	}

	@Override
	public class_2561 getTitle() {
		return class_2561.method_43471(id().toString());
	}

	@Override
	public Renderer getIcon() {
		return EntryStacks.of(ReiPlugin.iconMap.getOrDefault(recipeType, () -> class_1802.field_8250));
	}

	@Override
	public List<Widget> setupDisplay(RollingMachineDisplay display, Rectangle bounds) {
		Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
		List<Widget> widgets = new ArrayList<>();
		widgets.add(Widgets.createRecipeBase(bounds));
		widgets.add(ReiPlugin.createEnergyDisplay(new Rectangle(bounds.x + 8, bounds.y + 8, 14, 50), display.getEnergy(), ReiPlugin.EntryAnimation.downwards(5000), tooltipContext -> {
			List<class_2561> list = new ArrayList<>();
			list.add(class_2561.method_43471("techreborn.jei.recipe.energy"));
			list.add(class_2561.method_43469("techreborn.jei.recipe.running.cost", "E", display.getEnergy()).method_27692(class_124.field_1080));
			list.add(class_2561.method_43469("techreborn.jei.recipe.generator.total", display.getEnergy() * display.getTime()).method_27692(class_124.field_1080));
			list.add(class_2561.method_43470(""));
			list.add(ClientHelper.getInstance().getFormattedModFromIdentifier(class_2960.method_60655("techreborn", "")));
			return Tooltip.create(tooltipContext.getPoint(), list);
		}));
		widgets.add(ReiPlugin.createProgressBar(startPoint.x + 68, startPoint.y + 22, display.getTime() * 50, GuiBuilder.ProgressDirection.RIGHT));
		widgets.add(Widgets.createResultSlotBackground(new Point(startPoint.x + 95, startPoint.y + 19)));
		List<InputIngredient<EntryStack<?>>> input = display.getInputIngredients(3, 3);
		List<Slot> slots = new ArrayList<>();
		for (int y = 0; y < 3; y++)
			for (int x = 0; x < 3; x++)
				slots.add(Widgets.createSlot(new Point(startPoint.x + 10 + x * 18, startPoint.y + 1 + y * 18)).markInput());
		for (InputIngredient<EntryStack<?>> ingredient : input) {
			slots.get(ingredient.getIndex()).entries(ingredient.get());
		}
		widgets.addAll(slots);
		widgets.add(Widgets.createSlot(new Point(startPoint.x + 95, startPoint.y + 19)).entries(display.getOutputEntries().get(0)).disableBackground().markOutput());
		widgets.add(Widgets.createLabel(new Point(bounds.getMaxX() - 5, bounds.y + 5), class_2561.method_43469("techreborn.jei.recipe.processing.time.3", new DecimalFormat("###.##").format(display.getTime() / 20.0)))
			.shadow(false)
			.rightAligned()
			.color(0xFF404040, 0xFFBBBBBB)
		);
		return widgets;
	}
}
