/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.compat.rei.machine;

import com.google.common.collect.Lists;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import reborncore.client.gui.GuiBuilder;
import techreborn.TechReborn;
import techreborn.client.compat.rei.ReiPlugin;
import techreborn.compat.rei.FluidGeneratorRecipeDisplay;
import techreborn.init.TRContent;

import java.util.List;

public class FluidGeneratorRecipeCategory implements DisplayCategory<FluidGeneratorRecipeDisplay> {

	private final TRContent.Machine generator;
	private final CategoryIdentifier<? extends FluidGeneratorRecipeDisplay> identifier;

	public FluidGeneratorRecipeCategory(TRContent.Machine generator) {
		this.generator = generator;
		this.identifier = CategoryIdentifier.of(TechReborn.MOD_ID, generator.name);
	}

	@Override
	public CategoryIdentifier<? extends FluidGeneratorRecipeDisplay> getCategoryIdentifier() {
		return identifier;
	}

	@Override
	public class_2561 getTitle() {
		return class_2561.method_43471(identifier.toString());
	}

	@Override
	public Renderer getIcon() {
		return EntryStacks.of(generator);
	}

	@Override
	public List<Widget> setupDisplay(FluidGeneratorRecipeDisplay recipeDisplay, Rectangle bounds) {
		List<Widget> widgets = Lists.newArrayList();
		widgets.add(Widgets.createRecipeBase(bounds));
		widgets.add(ReiPlugin.createEnergyDisplay(new Rectangle(bounds.x + 108, bounds.y + 8, 14, 50), recipeDisplay.getTotalEnergy(), ReiPlugin.EntryAnimation.upwards(5000), tooltipContext -> {
			List<class_2561> list = Lists.newArrayList();
			list.add(class_2561.method_43471("techreborn.jei.recipe.energy"));
			list.add(class_2561.method_43469("techreborn.jei.recipe.generator.total", recipeDisplay.getTotalEnergy()).method_27692(class_124.field_1080));
			list.add(class_2561.method_43470(""));
			list.add(ClientHelper.getInstance().getFormattedModFromIdentifier(class_2960.method_60655("techreborn", "")));
			return Tooltip.create(tooltipContext.getPoint(), list);
		}));
		widgets.add(ReiPlugin.createFluidDisplay(new Rectangle(bounds.x + 16, bounds.y + 8, 16, 50), recipeDisplay.getInputEntries().get(0).get(0).cast(), ReiPlugin.EntryAnimation.downwards(5000)));
		widgets.add(ReiPlugin.createProgressBar(bounds.x + 76 - 16, bounds.y + 48 - 19, 5000, GuiBuilder.ProgressDirection.RIGHT));
		return widgets;
	}
}
