/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.compat.rei.machine;

import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import reborncore.common.crafting.RebornRecipe;
import techreborn.compat.rei.MachineRecipeDisplay;
import techreborn.client.compat.rei.ReiPlugin;

import java.util.Collections;
import java.util.List;

public abstract class AbstractMachineCategory<R extends RebornRecipe> implements DisplayCategory<MachineRecipeDisplay<R>> {
	private final class_3956<R> recipeType;

	public AbstractMachineCategory(class_3956<R> rebornRecipeType) {
		this.recipeType = rebornRecipeType;
	}

	private class_2960 id() {
		return class_7923.field_41188.method_10221(recipeType);
	}


	@Override
	public CategoryIdentifier<? extends MachineRecipeDisplay<R>> getCategoryIdentifier() {
		return CategoryIdentifier.of(id());
	}

	@Override
	public class_2561 getTitle() {
		return class_2561.method_43471(id().toString());
	}

	@Override
	public Renderer getIcon() {
		return EntryStacks.of(ReiPlugin.iconMap.getOrDefault(recipeType, () -> class_1802.field_8250));
	}

	@Override
	public DisplayRenderer getDisplayRenderer(MachineRecipeDisplay<R> recipe) {
		return SimpleDisplayRenderer.from(Collections.singletonList(recipe.getInputEntries().get(0)), recipe.getOutputEntries());
	}

	public EntryIngredient getInput(MachineRecipeDisplay<R> recipeDisplay, int index) {
		List<EntryIngredient> inputs = recipeDisplay.getInputEntries();
		return inputs.size() > index ? inputs.get(index) : EntryIngredient.empty();
	}

	public EntryIngredient getOutput(MachineRecipeDisplay<R> recipeDisplay, int index) {
		List<EntryIngredient> outputs = recipeDisplay.getOutputEntries();
		return outputs.size() > index ? outputs.get(index) : EntryIngredient.empty();
	}
}
