/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client;

import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3929;
import net.minecraft.class_465;
import reborncore.common.screen.BuiltScreenHandler;

public interface GuiFactory<T extends class_2586> extends class_3929.class_3930<BuiltScreenHandler, class_465<BuiltScreenHandler>> {
	class_465<BuiltScreenHandler> create(int syncId, class_1657 playerEntity, T blockEntity);

	@Override
	default class_465<BuiltScreenHandler> create(BuiltScreenHandler builtScreenHandler, class_1661 playerInventory, class_2561 text) {
		class_1657 playerEntity = playerInventory.field_7546;
		//noinspection unchecked
		T blockEntity = (T) builtScreenHandler.getBlockEntity();
		return create(builtScreenHandler.field_7763, playerEntity, blockEntity);
	}
}
