/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.storage.item;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_9334;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.WorldUtils;
import techreborn.blockentity.GuiType;
import techreborn.blockentity.storage.item.StorageUnitBaseBlockEntity;
import techreborn.init.TRBlockSettings;
import techreborn.init.TRContent;
import techreborn.items.tool.WrenchItem;

public class StorageUnitBlock extends BlockMachineBase {

	public final TRContent.StorageUnit unitType;

	public StorageUnitBlock(TRContent.StorageUnit unitType, String name) {
		super(TRBlockSettings.storageUnit(unitType.name.equals("buffer") || unitType.name.equals("crude"), name));
		this.unitType = unitType;
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new StorageUnitBaseBlockEntity(pos, state, unitType);
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		if (unitType == TRContent.StorageUnit.CREATIVE || worldIn.method_8608()) {
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}

		final StorageUnitBaseBlockEntity storageEntity = (StorageUnitBaseBlockEntity) worldIn.method_8321(pos);
		if (storageEntity == null) {
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}
		if (storageEntity.isFull()) {
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}

		class_1799 stackInHand = playerIn.method_5998(class_1268.field_5808);
		if (!storageEntity.method_5437(StorageUnitBaseBlockEntity.INPUT_SLOT, stackInHand)) {
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}

		class_1792 itemInHand = stackInHand.method_7909();
		if (itemInHand instanceof WrenchItem){
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}

		// Add item which is the same type (in users inventory) into storage
		for (int i = 0; i < playerIn.method_31548().method_5439() && !storageEntity.isFull(); i++) {
			class_1799 curStack = playerIn.method_31548().method_5438(i);
			if (curStack.method_7909() == itemInHand) {
				playerIn.method_31548().method_5447(i, storageEntity.processInput(curStack));
			}
		}

		return class_1269.field_5812;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
		final StorageUnitBaseBlockEntity storageEntity = (StorageUnitBaseBlockEntity) world.method_8321(pos);
		if (storageEntity == null){
			return 0;
		}
		float delta = (float) storageEntity.getCurrentCapacity()/storageEntity.getMaxCapacity();
		return class_3532.method_53063(delta, 0, 15);
	}

	@Override
	public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
		super.method_9606(state, world, pos, player);

		if (world.method_8608()) return;

		final StorageUnitBaseBlockEntity storageEntity = (StorageUnitBaseBlockEntity) world.method_8321(pos);
		if (storageEntity == null) {
			return;
		}
		if (storageEntity.method_5442()) {
			return;
		}

		class_1799 stackInHand = player.method_5998(class_1268.field_5808);

		// Let's assume that player is trying to break this block, rather than get an item from storage
		if (stackInHand.method_57826(class_9334.field_55878)) {
			return;
		}
		RebornInventory<StorageUnitBaseBlockEntity> inventory = storageEntity.getInventory();
		class_1799 out = inventory.method_5438(StorageUnitBaseBlockEntity.OUTPUT_SLOT);

		// Full stack if sneaking
		if (player.method_5715()) {
			WorldUtils.dropItem(out, world, player.method_24515());
			out.method_7939(0);
		} else {
			class_1799 dropStack = out.method_7972();
			dropStack.method_7939(1);
			WorldUtils.dropItem(dropStack, world, player.method_24515());
			out.method_7934(1);
		}

		inventory.setHashChanged();
	}

	@Override
	public IMachineGuiHandler getGui() {
		return GuiType.STORAGE_UNIT;
	}
}
