/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.storage.fluid;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.util.Tank;
import reborncore.common.util.WorldUtils;
import techreborn.blockentity.GuiType;
import techreborn.blockentity.storage.fluid.TankUnitBaseBlockEntity;
import techreborn.init.TRBlockSettings;
import techreborn.init.TRContent;
import techreborn.items.DynamicCellItem;

public class TankUnitBlock extends BlockMachineBase {

	public final TRContent.TankUnit unitType;

	public TankUnitBlock(TRContent.TankUnit unitType, String name) {
		super(TRBlockSettings.tankUnit(name));
		this.unitType = unitType;
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new TankUnitBaseBlockEntity(pos, state, unitType);
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		if (unitType == TRContent.TankUnit.CREATIVE || worldIn.method_8608()) {
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}

		final TankUnitBaseBlockEntity tankUnitEntity = (TankUnitBaseBlockEntity) worldIn.method_8321(pos);
		class_1799 stackInHand = playerIn.method_5998(class_1268.field_5808);
		class_1792 itemInHand = stackInHand.method_7909();

		// Assuming ItemFluidInfo is 1 BUCKET, for now only allow exact amount or less
		// I am only going to trust cells or buckets, they are known to be 1 BUCKET size, too suss of other items not abiding by that.
		if ((itemInHand instanceof DynamicCellItem || itemInHand instanceof class_1755)
				&& tankUnitEntity != null && itemInHand instanceof ItemFluidInfo itemFluid) {

			// Get fluid information from item
			class_3611 fluid = itemFluid.getFluid(stackInHand);
			int amount = stackInHand.method_7947();

			FluidValue fluidValue = FluidValue.BUCKET.multiply(amount);
			Tank tankInstance = tankUnitEntity.getTank();

			if(new FluidInstance(fluid).isEmptyFluid()){
				FluidValue amountInTank = tankInstance.getFluidInstance().getAmount();

				// If tank has content, fill up user's inventory
				if(amountInTank.equalOrMoreThan(FluidValue.BUCKET)){

					// Amount to transfer is whatever is lower (stack count or tank level)
					int amountTransferBuckets = (int) Math.min(amountInTank.getRawValue() / FluidValue.BUCKET.getRawValue(), stackInHand.method_7947());

					// Remove items from player
					stackInHand.method_7934(amountTransferBuckets);

					// Deposit into inventory, one by one (Stupid buckets)
					for(int i = 0; i < amountTransferBuckets; i++){
						class_1799 item = itemFluid.getFull(tankInstance.getFluid());

						boolean didInsert;

						class_1799 selectedStack = playerIn.method_6047();

						// Insert to select if it can, otherwise anywhere.
						if(selectedStack.method_7960()){
							playerIn.method_6122(class_1268.field_5808, item);
							didInsert = true;
						}else if(isSameItemFluid(item, selectedStack) && selectedStack.method_7947() < selectedStack.method_7914()) {
							selectedStack.method_7933(1);
							didInsert = true;
						}else {
							didInsert = playerIn.method_31548().method_7394(item);
						}


						// If didn't insert, just drop it.
						if(!didInsert){
							WorldUtils.dropItem(item,worldIn,  playerIn.method_24515());
						}
					}

					// Remove from tank
					tankInstance.setFluidAmount(tankInstance.getFluidAmount().subtract(
						FluidValue.BUCKET.multiply(amountTransferBuckets)));
				}else{
					return class_1269.field_5814;
				}
			}else{
				// If tank can fit fluid and amount, add it
				if (tankInstance.canFit(fluid, fluidValue)) {
					if (tankInstance.getFluidInstance().isEmpty()) {
						tankInstance.setFluidInstance(new FluidInstance(fluid, fluidValue));
					} else {
						tankInstance.modifyFluid(fluidInstance -> fluidInstance.addAmount(fluidValue));
					}

					// Give players the empty stuff back
					class_1799 returnStack = itemFluid.getEmpty();
					returnStack.method_7939(amount);
					playerIn.method_6122(class_1268.field_5808, returnStack);
				}
			}

			return class_1269.field_5812;
		}


		return super.method_55766(state, worldIn, pos, playerIn, hitResult);
	}

	boolean isSameItemFluid(class_1799 i1, class_1799 i2){
		// Only care about cells, buckets don't stack
		if(i1.method_7909() instanceof DynamicCellItem dc1 && i2.method_7909() instanceof DynamicCellItem dc2){
			return dc1.getFluid(i1).method_15780(dc2.getFluid(i2));
		}

		return false;
	}

	@Override
	public IMachineGuiHandler getGui() {
		return GuiType.TANK_UNIT;
	}
}
