/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.storage.energy;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import reborncore.api.ToolManager;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.util.WrenchUtils;
import techreborn.blockentity.storage.energy.lesu.LSUStorageBlockEntity;
import techreborn.init.TRBlockSettings;

/**
 * Energy storage block for LESU
 */
public class LSUStorageBlock extends BaseBlockEntityProvider {

	public LSUStorageBlock(String name) {
		super(TRBlockSettings.lsuStorage(name));
		BlockWrenchEventHandler.wrenchableBlocks.add(this);
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new LSUStorageBlockEntity(pos, state);
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 player, class_1799 itemstack) {
		super.method_9567(world, pos, state, player, itemstack);
		if (!world.method_8608() && world.method_8321(pos) instanceof LSUStorageBlockEntity blockEntity) {
			blockEntity.connectNeighbors();
		}
	}

	// Block
	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		class_1799 stack = playerIn.method_5998(class_1268.field_5808);
		class_2586 blockEntity = worldIn.method_8321(pos);

		// We extended BaseTileBlock. Thus, we should always have blockEntity entity. I hope.
		if (blockEntity == null) {
			return class_1269.field_5814;
		}

		if (!stack.method_7960() && ToolManager.INSTANCE.canHandleTool(stack)) {
			if (WrenchUtils.handleWrench(stack, worldIn, pos, playerIn, hitResult.method_17780())) {
				if (!worldIn.method_8608() && blockEntity instanceof LSUStorageBlockEntity target) {
					target.disconnectNeighbors();
				}
				return class_1269.field_5811;
			}
		}

		return super.method_55766(state, worldIn, pos, playerIn, hitResult);
	}

}
