/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.storage.energy;

import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import techreborn.blockentity.GuiType;
import techreborn.blockentity.storage.energy.idsu.InterdimensionalSUBlockEntity;

public class InterdimensionalSUBlock extends EnergyStorageBlock {

	public InterdimensionalSUBlock(String name) {
		super(GuiType.IDSU, name);
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new InterdimensionalSUBlockEntity(pos, state);
	}

	@Override
	public class_2680 method_9605(class_1750 context) {
		final class_2586 blockEntity = context.method_8045().method_8321(context.method_8037());
		if (blockEntity instanceof InterdimensionalSUBlockEntity) {
			((InterdimensionalSUBlockEntity) blockEntity).ownerUdid = context.method_8036().method_5667().toString();
		}
		return this.method_9564();
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
		super.method_9567(world, pos, state, placer, stack);
		class_2586 blockEntity = world.method_8321(pos);
		if (blockEntity instanceof InterdimensionalSUBlockEntity) {
			((InterdimensionalSUBlockEntity) blockEntity).ownerUdid = placer.method_5667().toString();
		}
	}

}
