/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.storage.energy;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import reborncore.api.ToolManager;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.ItemHandlerUtils;
import reborncore.common.util.WrenchUtils;
import techreborn.init.TRBlockSettings;



/**
 * Created by Rushmead
 */
public abstract class EnergyStorageBlock extends BaseBlockEntityProvider {
	public static final class_2754<class_2350> FACING = class_2741.field_12525;
	public final IMachineGuiHandler gui;

	public EnergyStorageBlock(IMachineGuiHandler gui, String name) {
		super(TRBlockSettings.energyStorage(name));
		this.method_9590(this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043));
		this.gui = gui;
		BlockWrenchEventHandler.wrenchableBlocks.add(this);
	}

	public void setFacing(class_2350 facing, class_1937 world, class_2338 pos) {
		world.method_8501(pos, world.method_8320(pos).method_11657(FACING, facing));
	}

	public class_2350 getFacing(class_2680 state) {
		return state.method_11654(FACING);
	}

	// BaseBlockEntityProvider
	@Override
	public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
		super.method_9567(worldIn, pos, state, placer, stack);
		class_2350 facing = placer.method_5735().method_10153();
		if (placer.method_36455() < -50) {
			facing = class_2350.field_11033;
		} else if (placer.method_36455() > 50) {
			facing = class_2350.field_11036;
		}
		setFacing(facing, worldIn, pos);
	}

	// Block
	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING);
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		class_1799 stack = playerIn.method_5998(class_1268.field_5808);
		class_2586 blockEntity = worldIn.method_8321(pos);

		// We extended BlockTileBase. Thus, we should always have blockEntity entity. I hope.
		if (blockEntity == null) {
			return class_1269.field_5814;
		}

		if (!stack.method_7960() && ToolManager.INSTANCE.canHandleTool(stack)) {
			if (WrenchUtils.handleWrench(stack, worldIn, pos, playerIn, hitResult.method_17780())) {
				return class_1269.field_5812;
			}
		}

		if (!playerIn.method_5715() && gui != null) {
			gui.open(playerIn, pos, worldIn);
			return class_1269.field_5812;
		}

		return super.method_55766(state, worldIn, pos, playerIn, hitResult);
	}

	@Override
	protected void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
		ItemHandlerUtils.dropContainedItems(worldIn, pos);
		super.method_66388(state, worldIn, pos, isMoving);
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
		return PowerAcceptorBlockEntity.calculateComparatorOutputFromEnergy(world.method_8321(pos));
	}

	@Override
	public class_2680 method_9598(class_2680 state, class_2470 rotation) {
		return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
	}
}
