/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.misc;

import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import reborncore.common.util.WorldUtils;
import techreborn.config.TechRebornConfig;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockSettings;
import techreborn.init.TRContent;
import techreborn.items.tool.TreeTapItem;
import techreborn.items.tool.basic.ElectricTreetapItem;

/**
 * Created by modmuss50 on 19/02/2016.
 */
public class BlockRubberLog extends class_2465 {

	public static final class_2754<class_2350> SAP_SIDE = class_2741.field_12481;
	public static final class_2746 HAS_SAP = class_2746.method_11825("hassap");
	public static final class_2746 SHOULD_SAP = class_2746.method_11825("shouldsap");

	public BlockRubberLog(String name) {
		super(TRBlockSettings.rubberLog(name));
		this.method_9590(this.method_9564().method_11657(SAP_SIDE, class_2350.field_11043).method_11657(HAS_SAP, false).method_11657(SHOULD_SAP, true).method_11657(field_11459, class_2350.class_2351.field_11052));
		FlammableBlockRegistry.getDefaultInstance().add(this, 5, 5);
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(SAP_SIDE, HAS_SAP, SHOULD_SAP);
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
		super.method_9567(world, pos, state, placer, itemStack);
		if (placer instanceof class_1657) {
			world.method_8501(pos, state.method_11657(SHOULD_SAP, false));
		}
	}

	/* FIXME @Override
	public boolean isIn(Tag<Block> tagIn) {
		return tagIn == BlockTags.LOGS;
	}*/

	@SuppressWarnings("deprecation")
	@Override
	public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
		int i = 4;
		int j = i + 1;
		if (worldIn instanceof class_3218 && worldIn.method_22343(pos.method_10069(-j, -j, -j), pos.method_10069(j, j, j))) {
			for (class_2338 blockpos : class_2338.method_10097(pos.method_10069(-i, -i, -i), pos.method_10069(i, i, i))) {
				class_2680 state1 = worldIn.method_8320(blockpos);
				if (state1.method_26164(class_3481.field_15503)) {
					state1.method_26192((class_3218) worldIn, blockpos, worldIn.method_8409());
					state1.method_26199((class_3218) worldIn, blockpos, worldIn.method_8409());
				}
			}
		}
		return super.method_9576(worldIn, pos, state, player);
	}

	@Override
	public void method_9514(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
		super.method_9514(state, worldIn, pos, random);
		if (state.method_11654(field_11459) != class_2350.class_2351.field_11052) return;
		if (!state.method_11654(SHOULD_SAP)) return;
		if (state.method_11654(HAS_SAP)) return;

		if (random.method_43048(50) == 0) {
			class_2350 facing = class_2350.method_10139(random.method_43048(4));
			if (worldIn.method_8320(pos.method_10079(class_2350.field_11033, 1)).method_26204() == this
					&& worldIn.method_8320(pos.method_10084()).method_26204() == this) {
				worldIn.method_8501(pos, state.method_11657(HAS_SAP, true).method_11657(SAP_SIDE, facing));
			}
		}
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		class_1799 stack = playerIn.method_5998(class_1268.field_5808);
		if (stack.method_7960()) {
			return class_1269.field_5811;
		}

		if ((stack.method_7909() instanceof ElectricTreetapItem item && item.getStoredEnergy(stack) > 20) || stack.method_7909() instanceof TreeTapItem) {
			if (state.method_11654(HAS_SAP) && state.method_11654(SAP_SIDE) == hitResult.method_17780()) {
				worldIn.method_8501(pos, state.method_11657(HAS_SAP, false).method_11657(SAP_SIDE, class_2350.method_10139(0)));
				worldIn.method_8396(playerIn, pos, ModSounds.SAP_EXTRACT, class_3419.field_15245, 0.6F, 1F);
				if (worldIn.method_8608()) {
					return class_1269.field_5812;
				}
				if (stack.method_7909() instanceof ElectricTreetapItem item) {
					item.tryUseEnergy(stack, TechRebornConfig.electricTreetapCost);
				} else {
					stack.method_7970(1, playerIn, class_1304.field_6173);
				}
				if (!playerIn.method_31548().method_7394(TRContent.Parts.SAP.getStack())) {
					WorldUtils.dropItem(TRContent.Parts.SAP.getStack(), worldIn, pos.method_10093(hitResult.method_17780()));
				}
				if (playerIn instanceof class_3222 && !TechRebornConfig.vanillaUnlockRecipes) {
					TRRecipeHandler.unlockTRRecipes((class_3222) playerIn);
				}
				return class_1269.field_5812;
			}
		}
		return class_1269.field_5811;
	}
}
