/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.misc;


import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_9381;
import techreborn.init.TRBlockSettings;

public class BlockRubberLeaves extends class_2397 {
	public static final MapCodec<BlockRubberLeaves> CODEC = RecordCodecBuilder.mapCodec(
		instance -> instance.group(method_54096()).apply(instance, BlockRubberLeaves::new)
	);

	public BlockRubberLeaves(String name) {
		super(0.01F, TRBlockSettings.rubberLeaves(name));
		FlammableBlockRegistry.getDefaultInstance().add(this, 30, 60);
	}

	public BlockRubberLeaves(class_4970.class_2251 settings) {
		super(0.01F, settings);
	}

	@Override
	public MapCodec<BlockRubberLeaves> method_53969() {
		return field_46280;
	}

	@Override
	protected void method_67234(class_1937 world, class_2338 pos, class_5819 random) {
		class_9381 entityEffectParticleEffect = class_9381.method_58256(class_2398.field_55880, 0xff4d6148);
		class_5945.method_49099(world, pos, random, entityEffectParticleEffect);
	}
}
