/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.misc;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import reborncore.common.multiblock.BlockMultiblockBase;
import techreborn.blockentity.machine.multiblock.casing.MachineCasingBlockEntity;
import techreborn.init.TRBlockSettings;
import techreborn.utils.DirectionUtils;

public class BlockMachineCasing extends BlockMultiblockBase {

	public final int heatCapacity;

	public BlockMachineCasing(int heatCapacity, String name) {
		super(TRBlockSettings.machineCasing(name));
		method_9590(method_9564().method_11657(DirectionUtils.HORIZONTAL_NEIGHBORS, 0));
		this.heatCapacity = heatCapacity;
	}

	@Override
	public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(DirectionUtils.HORIZONTAL_NEIGHBORS);
	}

	@Override
	public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
		super.method_66388(state, world, pos, moved);
		DirectionUtils.removeHorizontalNeighbor(world, pos, state, block -> block instanceof BlockMachineCasing);
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
		super.method_9567(world, pos, state, placer, itemStack);
		DirectionUtils.addHorizontalNeighbor(world, pos, state, block -> block instanceof BlockMachineCasing);
	}

	public static int getHeatFromState(class_2680 state) {
		class_2248 block = state.method_26204();
		if (block instanceof BlockMachineCasing casing) {
			return casing.heatCapacity;
		}

		return 0;
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new MachineCasingBlockEntity(pos, state);
	}
}
