/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.misc;

import org.jetbrains.annotations.Nullable;
import reborncore.api.ToolManager;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.util.WrenchUtils;
import techreborn.blockentity.machine.misc.AlarmBlockEntity;
import techreborn.init.TRBlockSettings;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockAlarm extends BaseBlockEntityProvider {
	public static final class_2754<class_2350> FACING = class_2741.field_12525;
	public static final class_2746 ACTIVE = BlockMachineBase.ACTIVE;
	protected final class_265[] shape;

	public BlockAlarm(String name) {
		super(TRBlockSettings.alarm(name));
		this.method_9590(this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(ACTIVE, false));
		this.shape = GenCuboidShapes(3, 10);
		BlockWrenchEventHandler.wrenchableBlocks.add(this);
	}

	private class_265[] GenCuboidShapes(double depth, double width) {
		double culling = (16.0D - width) / 2;
		return new class_265[]{
				method_9541(culling, 16.0 - depth, culling, 16.0 - culling, 16.0D, 16.0 - culling),
				method_9541(culling, 0.0D, culling, 16.0D - culling, depth, 16.0 - culling),
				method_9541(culling, culling, 16.0 - depth, 16.0 - culling, 16.0 - culling, 16.0D),
				method_9541(culling, culling, 0.0D, 16.0 - culling, 16.0 - culling, depth),
				method_9541(16.0 - depth, culling, culling, 16.0D, 16.0 - culling, 16.0 - culling),
				method_9541(0.0D, culling, culling, depth, 16.0 - culling, 16.0 - culling)
		};
	}

	public static boolean isActive(class_2680 state) {
		return state.method_11654(ACTIVE);
	}

	public static class_2350 getFacing(class_2680 state) {
		return state.method_11654(FACING);
	}

	public static void setFacing(class_2350 facing, class_1937 world, class_2338 pos) {
		world.method_8501(pos, world.method_8320(pos).method_11657(FACING, facing));
	}

	public static void setActive(boolean active, class_1937 world, class_2338 pos) {
		class_2350 facing = world.method_8320(pos).method_11654(FACING);
		class_2680 state = world.method_8320(pos).method_11657(ACTIVE, active).method_11657(FACING, facing);
		world.method_8652(pos, state, 3);
	}

	// BaseTileBlock
	@Nullable
	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new AlarmBlockEntity(pos, state);
	}

	// Block
	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING, ACTIVE);
	}

	@Nullable
	@Override
	public class_2680 method_9605(class_1750 context) {
		for (class_2350 facing : context.method_7718()) {
			class_2680 state = this.method_9564().method_11657(FACING, facing.method_10153());
			if (state.method_26184(context.method_8045(), context.method_8037())) {
				return state;
			}
		}
		return null;
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		class_1799 stack = playerIn.method_5998(class_1268.field_5808);
		class_2586 blockEntity = worldIn.method_8321(pos);

		// We extended BaseTileBlock. Thus, we should always have blockEntity entity. I hope.
		if (blockEntity == null) {
			return class_1269.field_5814;
		}

		if (!stack.method_7960() && ToolManager.INSTANCE.canHandleTool(stack)) {
			if (WrenchUtils.handleWrench(stack, worldIn, pos, playerIn, hitResult.method_17780())) {
				return class_1269.field_5812;
			}
		}

		if (playerIn.method_5715()) {
			((AlarmBlockEntity) blockEntity).rightClick(playerIn);
			return class_1269.field_5812;

		}

		return super.method_55766(state, worldIn, pos, playerIn, hitResult);
	}

	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11458;
	}


	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 shapeContext) {
		return shape[getFacing(state).ordinal()];
	}


	@Override
	public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
		tooltip.add(class_2561.method_43471("techreborn.tooltip.alarm").method_27692(class_124.field_1080));
	}

}
