/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.machine.tier1;

import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.WorldUtils;
import techreborn.blockentity.machine.tier1.ResinBasinBlockEntity;
import techreborn.init.TRBlockSettings;
import techreborn.init.TRContent;

import java.util.function.BiFunction;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class ResinBasinBlock extends BaseBlockEntityProvider {

	public static final class_2754<class_2350> FACING = class_2741.field_12481;
	public static final class_2746 POURING = class_2746.method_11825("pouring");
	public static final class_2746 FULL = class_2746.method_11825("full");
	protected static final class_265 SHAPE = class_2248.method_9541(0d,0d, 0d, 16d, 8d, 16d);
	final BiFunction<class_2338, class_2680, class_2586> blockEntityClass;

	public ResinBasinBlock(BiFunction<class_2338, class_2680, class_2586> blockEntityClass, String name) {
		super(TRBlockSettings.resinBasin(name));
		this.blockEntityClass = blockEntityClass;

		this.method_9590(
				this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(POURING, false).method_11657(FULL, false));
	}

	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		return SHAPE;
	}

	public void setFacing(class_2350 facing, class_1937 world, class_2338 pos) {
		world.method_8501(pos, world.method_8320(pos).method_11657(FACING, facing));
	}

	// Block
	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING, POURING, FULL);
	}

	public class_2350 getFacing(class_2680 state) {
		return state.method_11654(FACING);
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
		if (world == null || world.method_8608() || player == null || pos == null || !(world.method_8321(pos) instanceof ResinBasinBlockEntity basin))
			return class_1269.field_5811;
		class_1799 sap = basin.empty();
		if (sap.method_7960())
			return class_1269.field_5811;
		player.method_31548().method_7398(sap);
		return class_1269.field_5812;
	}

	@Override
	public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
		super.method_9567(worldIn, pos, state, placer, stack);
		if (worldIn.method_8608()) return;

		class_2350 facing = placer.method_5735().method_10153();
		setFacing(facing, worldIn, pos);

		// Drop item if not next to log and yell at user
		if (worldIn.method_8320(pos.method_10093(facing.method_10153())).method_26204() != TRContent.RUBBER_LOG) {
			worldIn.method_8501(pos, class_2246.field_10124.method_9564());
			WorldUtils.dropItem(this.method_8389(), worldIn, pos);
			if (placer instanceof class_3222 player) {
				player.method_64398(class_2561.method_43471("techreborn.tooltip.invalid_basin_placement"));
			}
		}
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		if (blockEntityClass == null) {
			return null;
		}
		return blockEntityClass.apply(pos, state);
	}

	@Override
	public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
		class_2586 blockEntity = world.method_8321(pos);
		if (blockEntity instanceof MachineBaseBlockEntity) {
			((MachineBaseBlockEntity) blockEntity).onBreak(world, player, pos, state);
		}

		return super.method_9576(world, pos, state, player);
	}
}
