/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.machine.tier1;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import reborncore.api.IToolDrop;
import reborncore.api.ToolManager;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.util.StringUtils;
import techreborn.blockentity.GuiType;
import techreborn.blockentity.machine.tier1.PlayerDetectorBlockEntity;
import techreborn.init.TRBlockSettings;

public class PlayerDetectorBlock extends BlockMachineBase {

	public static final class_2754<PlayerDetectorType> TYPE = class_2754.method_11850("type", PlayerDetectorType.class);

	public PlayerDetectorBlock(String name) {
		super(TRBlockSettings.playerDetector(name), true);
		this.method_9590(this.method_9595().method_11664().method_11657(TYPE, PlayerDetectorType.ALL));
	}

	// BlockMachineBase
	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new PlayerDetectorBlockEntity(pos, state);
	}

	@Override
	public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
		super.method_9567(worldIn, pos, state, placer, stack);
		class_2586 blockEntity = worldIn.method_8321(pos);
		if (blockEntity instanceof PlayerDetectorBlockEntity) {
			((PlayerDetectorBlockEntity) blockEntity).ownerUdid = placer.method_5667().toString();
		}
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		if (!playerIn.method_7294()){
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}
		class_2586 blockEntity = worldIn.method_8321(pos);
		if (blockEntity == null) {
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}

		class_1799 stack = playerIn.method_5998(class_1268.field_5808);
		PlayerDetectorType type = state.method_11654(TYPE);
		PlayerDetectorType newType = type;
		class_124 color = class_124.field_1060;

		if (!stack.method_7960() && ToolManager.INSTANCE.canHandleTool(stack)) {
			if (ToolManager.INSTANCE.handleTool(stack, pos, worldIn, playerIn, hitResult.method_17780(), false)) {
				if (playerIn.method_5715()) {
					if (blockEntity instanceof IToolDrop) {
						class_1799 drop = ((IToolDrop) blockEntity).getToolDrop(playerIn);
						if (drop == null) {
							return class_1269.field_5811;
						}
						if (!drop.method_7960()) {
							method_9577(worldIn, pos, drop);
						}
						if (!worldIn.method_8608()) {
							worldIn.method_8652(pos, class_2246.field_10124.method_9564(), 2);
						}
						return class_1269.field_5812;
					}
				} else {
					if (type == PlayerDetectorType.ALL) {
						newType = PlayerDetectorType.OTHERS;
						color = class_124.field_1061;
					} else if (type == PlayerDetectorType.OTHERS) {
						newType = PlayerDetectorType.YOU;
						color = class_124.field_1078;
					} else if (type == PlayerDetectorType.YOU) {
						newType = PlayerDetectorType.ALL;
					}
					worldIn.method_8501(pos, state.method_11657(TYPE, newType));
				}
			}
		}

		if (playerIn instanceof class_3222 serverPlayerEntity) {
			serverPlayerEntity.method_7353(class_2561.method_43471("techreborn.message.detects")
											.method_27692(class_124.field_1080)
											.method_27693(" ")
											.method_10852(
												class_2561.method_43470(StringUtils.toFirstCapital(newType.method_15434()))
													.method_27692(color)
											), true);
		}

		if (getGui() != null && !playerIn.method_5715()) {
			getGui().open(playerIn, pos, worldIn);
			return class_1269.field_5812;
		}

		return class_1269.field_5812;
	}

	@Override
	public IMachineGuiHandler getGui() {
		return GuiType.PLAYER_DETECTOR;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(TYPE);
	}

	// AbstractBlock
	@SuppressWarnings("deprecation")
	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@SuppressWarnings("deprecation")
	@Override
	public int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
		class_2586 entity = blockAccess.method_8321(pos);
		if (entity instanceof PlayerDetectorBlockEntity) {
			return ((PlayerDetectorBlockEntity) entity).isProvidingPower() ? 15 : 0;
		}
		return 0;
	}

	public enum PlayerDetectorType implements class_3542 {
		ALL("all"), OTHERS("others"), YOU("you");

		private final String name;

		PlayerDetectorType(String name) {
			this.name = name;
		}

		@Override
		public String toString() {
			return this.name;
		}

		@Override
		public String method_15434() {
			return this.name;
		}
	}
}
