/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.machine.tier0;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import techreborn.blockentity.GuiType;
import techreborn.blockentity.machine.iron.IronFurnaceBlockEntity;
import techreborn.blocks.GenericMachineBlock;

public class IronFurnaceBlock extends GenericMachineBlock {

	public IronFurnaceBlock(String name) {
		super(GuiType.IRON_FURNACE, IronFurnaceBlockEntity::new, name);
	}

	// Block
	@Override
	public void method_9496(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_5819 rand) {
		if (!isActive(stateIn)) {
			return;
		}

		final double x = (double) pos.method_10263() + 0.5D;
		final double y = (double) pos.method_10264() + 2.0D / 16.0D + rand.method_43058() * 5.0D / 16.0D;
		final double z = (double) pos.method_10260() + 0.5D;
		if (rand.method_43058() < 0.1D) {
			worldIn.method_8486(x, y, z, class_3417.field_15006, class_3419.field_15245, 1.0F, 1.0F, false);
		}

		class_2350 facing = stateIn.method_11654(FACING);
		class_2350.class_2351 facing$Axis = facing.method_10166();
		double double_5 = rand.method_43058() * 0.6D - 0.3D;
		double deltaX = facing$Axis == class_2350.class_2351.field_11048 ? (double) facing.method_10148() * 0.52D : double_5;
		double deltaZ = facing$Axis == class_2350.class_2351.field_11051 ? (double) facing.method_10165() * 0.52D : double_5;
		worldIn.method_8406(class_2398.field_11251, x + deltaX, y, z + deltaZ, 0.0D, 0.0D, 0.0D);
		worldIn.method_8406(class_2398.field_11240, x + deltaX, y, z + deltaZ, 0.0D, 0.0D, 0.0D);
	}
}
