/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.generator;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import techreborn.blockentity.GuiType;
import techreborn.blockentity.generator.SolarPanelBlockEntity;
import techreborn.init.TRBlockSettings;
import techreborn.init.TRContent.SolarPanels;

/**
 * Created by modmuss50 on 25/02/2016.
 */
public class BlockSolarPanel extends BlockMachineBase {

	public final SolarPanels panelType;

	public BlockSolarPanel(SolarPanels panel, String name) {
		super(TRBlockSettings.solarPanel(name));
		this.panelType = panel;
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new SolarPanelBlockEntity(pos, state, panelType);
	}

	@Override
	public IMachineGuiHandler getGui() {
		if (this.panelType == SolarPanels.CREATIVE) {
			return null;
		}
		return GuiType.SOLAR_PANEL;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
		return PowerAcceptorBlockEntity.calculateComparatorOutputFromEnergy(world.method_8321(pos));
	}
}
