/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.generator;

import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.util.Torus;
import techreborn.blockentity.GuiType;
import techreborn.blockentity.machine.multiblock.FusionControlComputerBlockEntity;
import techreborn.init.TRBlockSettings;
import techreborn.init.TRContent;
import techreborn.init.TRDamageTypes;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;

public class BlockFusionControlComputer extends BlockMachineBase {
	public BlockFusionControlComputer(String name) {
		super(TRBlockSettings.fusionControlComputer(name));
	}

	@Override
	protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		final FusionControlComputerBlockEntity blockEntityFusionControlComputer = (FusionControlComputerBlockEntity) world.method_8321(pos);
		if (!player.method_5998(hand).method_7960() && (player.method_5998(hand).method_7909() == TRContent.Machine.FUSION_COIL.method_8389())) {
			List<class_2338> coils = Torus.generate(blockEntityFusionControlComputer.method_11016(), blockEntityFusionControlComputer.size);
			boolean placed = false;
			for (class_2338 coil : coils) {
				if (player.method_5998(hand).method_7960()) {
					return class_1269.field_5812;
				}
				if (world.method_8320(coil).method_26166(new class_1750(new class_1838(player, hand, hit)))
					&& world.method_8320(pos).method_26204() != TRContent.Machine.FUSION_COIL.block) {
					world.method_8501(coil, TRContent.Machine.FUSION_COIL.block.method_9564());
					if (!player.method_68878()) {
						player.method_5998(hand).method_7934(1);
					}
					placed = true;
				}
			}
			if (placed) {
				return class_1269.field_5812;
			}

		}
		return super.method_55765(stack, state, world, pos, player, hand, hit);
	}

	@Override
	public IMachineGuiHandler getGui() {
		return GuiType.FUSION_CONTROLLER;
	}

	@Override
	public void method_9591(final class_1937 worldIn, final class_2338 pos, final class_2680 state,  final class_1297 entityIn) {
		super.method_9591(worldIn, pos, state, entityIn);
		if (!worldIn.method_8608() && worldIn.method_8321(pos) instanceof FusionControlComputerBlockEntity blockEntity) {
			if (blockEntity.craftingTickTime != 0 && blockEntity.isShapeValid()) {
				entityIn.method_64397((class_3218) worldIn, TRDamageTypes.create(worldIn, TRDamageTypes.FUSION), 200F);
			}
		}
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new FusionControlComputerBlockEntity(pos, state);
	}

	@Override
	public boolean isAdvanced() {
		return true;
	}
}
