/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.generator;

import reborncore.api.ToolManager;
import reborncore.common.BaseBlock;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockSettings;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3965;

public class BlockFusionCoil extends BaseBlock {

	public BlockFusionCoil(String name) {
		super(TRBlockSettings.fusionCoil(name));
	}

	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn,
							class_3965 hitResult) {

		class_1799 tool = playerIn.method_5998(class_1268.field_5808);
		if (tool.method_7960()) return class_1269.field_5811;
		if (!ToolManager.INSTANCE.canHandleTool(tool)) return class_1269.field_5811;

		if (ToolManager.INSTANCE.handleTool(tool, pos, worldIn, playerIn, hitResult.method_17780(), false)) {
			if (!playerIn.method_5715()) return class_1269.field_5811;
			class_1799 drop = new class_1799(this);
			method_9577(worldIn, pos, drop);
			worldIn.method_43128(null, playerIn.method_23317(), playerIn.method_23318(), playerIn.method_23321(), ModSounds.BLOCK_DISMANTLE,
					class_3419.field_15245, 0.6F, 1F);
			if (!worldIn.method_8608()) {
				worldIn.method_8652(pos, class_2246.field_10124.method_9564(), 2);
			}
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
		super.appendTooltip(stack, context, tooltip, options);
		tooltip.add(class_2561.method_43471("techreborn.tooltip.fusion_coil").method_27692(class_124.field_1078));
	}
}
