/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.cable;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public final class CableShapeUtil {

	private static final Map<class_2680, class_265> SHAPE_CACHE = new IdentityHashMap<>();

	private static class_265 getStateShape(class_2680 state) {
		CableBlock cableBlock = (CableBlock) state.method_26204();

		final double size = cableBlock.type.cableThickness;
		final class_265 baseShape = class_259.method_1081(size, size, size, 1 - size, 1 - size, 1 - size);

		final List<class_265> connections = new ArrayList<>();
		for (class_2350 dir : class_2350.values()) {
			if (state.method_11654(CableBlock.PROPERTY_MAP.get(dir))) {
				double[] mins = new double[] { size, size, size };
				double[] maxs = new double[] { 1 - size, 1 - size, 1 - size };
				int axis = dir.method_10166().ordinal();
				if (dir.method_10171() == class_2350.class_2352.field_11056) {
					maxs[axis] = 1;
				} else {
					mins[axis] = 0;
				}
				connections.add(class_259.method_1081(mins[0], mins[1], mins[2], maxs[0], maxs[1], maxs[2]));
			}
		}
		return class_259.method_17786(baseShape, connections.toArray(new class_265[]{}));
	}

	public static class_265 getShape(class_2680 state) {
		return SHAPE_CACHE.computeIfAbsent(state, CableShapeUtil::getStateShape);
	}

}
