/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.cable;

import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;
import reborncore.api.ToolManager;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.util.WrenchUtils;
import techreborn.api.events.CableElectrocutionEvent;
import techreborn.blockentity.cable.CableBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockSettings;
import techreborn.init.TRContent;
import techreborn.init.TRDamageTypes;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9904;

/**
 * Created by modmuss50 on 19/05/2017.
 */
public class CableBlock extends class_2237 implements class_3737 {

	public static final class_2746 EAST = class_2741.field_12487;
	public static final class_2746 WEST = class_2741.field_12527;
	public static final class_2746 NORTH = class_2741.field_12489;
	public static final class_2746 SOUTH = class_2741.field_12540;
	public static final class_2746 UP = class_2741.field_12519;
	public static final class_2746 DOWN = class_2741.field_12546;
	public static final class_2746 WATERLOGGED = class_2741.field_12508;
	public static final class_2746 COVERED = class_2746.method_11825("covered");

	public static final Map<class_2350, class_2746> PROPERTY_MAP = class_156.method_654(new HashMap<>(), map -> {
		map.put(class_2350.field_11034, EAST);
		map.put(class_2350.field_11039, WEST);
		map.put(class_2350.field_11043, NORTH);
		map.put(class_2350.field_11035, SOUTH);
		map.put(class_2350.field_11036, UP);
		map.put(class_2350.field_11033, DOWN);
	});

	public final TRContent.Cables type;

	public CableBlock(TRContent.Cables type, String name) {
		super(TRBlockSettings.cable(name));
		this.type = type;
		method_9590(this.method_9595().method_11664().method_11657(EAST, false).method_11657(WEST, false).method_11657(NORTH, false)
				.method_11657(SOUTH, false).method_11657(UP, false).method_11657(DOWN, false).method_11657(WATERLOGGED, false).method_11657(COVERED, false));
		BlockWrenchEventHandler.wrenchableBlocks.add(this);
	}

	@Override
	protected MapCodec<? extends class_2237> method_53969() {
		throw new IllegalStateException("CableBlock does not support getCodec!");
	}

	// BlockWithEntity
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11458;
	}

	@Nullable
	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new CableBlockEntity(pos, state, type);
	}

	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
		return (world1, pos, state1, blockEntity) -> ((CableBlockEntity) blockEntity).tick(world1, pos, state1, (CableBlockEntity) blockEntity);
	}

	// Block
	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
		class_1799 stack = playerIn.method_5998(class_1268.field_5808);
		class_2586 blockEntity = worldIn.method_8321(pos);

		// We should always have blockEntity entity. I hope.
		if (blockEntity == null) {
			return class_1269.field_5814;
		}

		if (stack.method_7960()) {
			return super.method_55766(state, worldIn, pos, playerIn, hitResult);
		}

		if (ToolManager.INSTANCE.canHandleTool(stack)) {
			if (state.method_11654(COVERED) && !playerIn.method_5715()) {
				((CableBlockEntity) blockEntity).setCover(null);
				worldIn.method_8501(pos, state.method_11657(COVERED, false));
				worldIn.method_8396(playerIn, pos, class_3417.field_15215, class_3419.field_15245, 0.6F, 1.0F);
				if (!worldIn.method_8608()) {
					class_1264.method_5449(worldIn, pos.method_10263(), pos.method_10264(), pos.method_10260(), TRContent.Plates.WOOD.getStack());
				}
				return class_1269.field_5812;
			}

			if (WrenchUtils.handleWrench(stack, worldIn, pos, playerIn, hitResult.method_17780())) {
				return class_1269.field_5812;
			}
		}

		if (!state.method_11654(COVERED) && !type.canKill
				&& stack.method_7909() == TRContent.Plates.WOOD.method_8389()) {
			worldIn.method_8501(pos, state.method_11657(COVERED, true));
			worldIn.method_8396(playerIn, pos, class_3417.field_14718, class_3419.field_15245, 0.6F, 1.0F);
			if (!worldIn.method_8608() && !playerIn.method_68878()) {
				stack.method_7934(1);
			}
			return class_1269.field_5812;
		}

		return super.method_55766(state, worldIn, pos, playerIn, hitResult);
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(EAST, WEST, NORTH, SOUTH, UP, DOWN, WATERLOGGED, COVERED);
	}

	@Override
	public class_2680 method_9605(class_1750 context) {
		return method_9564()
				.method_11657(WATERLOGGED, context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910);
	}

	@Override
	public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
		if (state.method_11654(WATERLOGGED) && world instanceof class_1936 worldIn) {
			worldIn.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
		}
		return state;
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, @Nullable class_9904 wireOrientation, boolean notify) {
		if (world.method_8321(pos) instanceof CableBlockEntity cable) {
			cable.neighborUpdate();
		}
		super.method_9612(state, world, pos, block, wireOrientation, notify);
	}

	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 shapeContext) {
		if (state.method_11654(COVERED)) {
			return class_259.method_1077();
		}
		return CableShapeUtil.getShape(state);
	}

	@Override
	public class_265 method_9571(class_2680 state) {
		return CableShapeUtil.getShape(state);
	}

	@Override
	protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler, boolean bl) {
		super.method_9548(state, world, pos, entity, handler, bl);
		if (!type.canKill) {
			return;
		}
		if (!(entity instanceof class_1309)) {
			return;
		}

		class_2586 blockEntity = world.method_8321(pos);
		if (blockEntity == null) {
			return;
		}
		if (!(blockEntity instanceof CableBlockEntity blockEntityCable)) {
			return;
		}

		if (blockEntityCable.getEnergy() <= 0) {
			return;
		}

		if (!CableElectrocutionEvent.EVENT.invoker().electrocute((class_1309) entity, type, pos, world, blockEntityCable)) {
			return;
		}

		if (TechRebornConfig.uninsulatedElectrocutionDamage) {
			if (type == TRContent.Cables.HV) {
				entity.method_5639(1);
			}

			if (world instanceof class_3218 serverWorld) {
				entity.method_64397(serverWorld, TRDamageTypes.create(world, TRDamageTypes.ELECTRIC_SHOCK), 1F);
			}
			blockEntityCable.setEnergy(0);
		}
		if (TechRebornConfig.uninsulatedElectrocutionSound) {
			world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), ModSounds.CABLE_SHOCK, class_3419.field_15245,
					0.6F, 1F);
		}
		if (TechRebornConfig.uninsulatedElectrocutionParticles) {
			world.method_8406(class_2398.field_11205, entity.method_23317(), entity.method_23318(), entity.method_23321(), 0, 0, 0);
		}
	}

	@Override
	public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
		return !state.method_11654(COVERED) && class_3737.super.method_10311(world, pos, state, fluidState);
	}

	@Override
	public boolean method_10310(class_1309 player, class_1922 view, class_2338 pos, class_2680 state, class_3611 fluid) {
		return !state.method_11654(COVERED) && class_3737.super.method_10310(player, view, pos, state, fluid);
	}

	@Override
	public class_3610 method_9545(class_2680 state) {
		return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
	}

	@Override
	public class_2680 getAppearance(class_2680 state, class_1920 renderView, class_2338 pos, class_2350 side, @Nullable class_2680 sourceState, @Nullable class_2338 sourcePos) {
		if (state.method_11654(COVERED)) {
			final class_2680 cover;

			if (renderView.getBlockEntityRenderData(pos) instanceof class_2680 blockState) {
				cover = blockState;
			} else {
				cover = class_2246.field_10161.method_9564();
			}

			return cover;
		}

		return super.getAppearance(state, renderView, pos, side, sourceState, sourcePos);
	}
}
