/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.storage.energy;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.RebornInventory;
import techreborn.blocks.storage.energy.EnergyStorageBlock;

/**
 * Created by Rushmead
 */
public class EnergyStorageBlockEntity extends PowerAcceptorBlockEntity implements IToolDrop, InventoryProvider {

	public final RebornInventory<EnergyStorageBlockEntity> inventory;
	public final String name;
	public final class_2248 wrenchDrop;
	public int maxInput;
	public int maxOutput;
	public int maxStorage;

	public EnergyStorageBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state, String name, int invSize, class_2248 wrenchDrop, RcEnergyTier tier, int maxStorage) {
		super(blockEntityType, pos, state);
		inventory = new RebornInventory<>(invSize, name + "BlockEntity", 64, this);
		this.wrenchDrop = wrenchDrop;
		this.name = name;
		this.maxInput = tier.getMaxInput();
		this.maxOutput = tier.getMaxOutput();
		this.maxStorage = maxStorage;
		// Call it again after we have proper values for energy I\O
		checkTier();
	}

	// PowerAcceptorBlockEntity
	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);
		if (world == null || world.method_8608()) {
			return;
		}

		if (!inventory.method_5438(0).method_7960()) {
			discharge(0);
		}
		if (!inventory.method_5438(1).method_7960()) {
			charge(1);
		}
	}

	@Override
	public boolean canAcceptEnergy(@Nullable class_2350 side) {
		return getFacing() != side;
	}

	@Override
	public boolean canProvideEnergy(@Nullable class_2350 side) {
		// side == null allows to move energy from BE to chargeable item.
		return side == null || getFacing() == side;
	}

	@Override
	public long getBaseMaxPower() {
		return maxStorage;
	}

	@Override
	public long getBaseMaxOutput() {
		return maxOutput;
	}

	@Override
	public long getBaseMaxInput() {
		return maxInput;
	}

	// MachineBaseBlockEntity
	@Override
	public void setFacing(class_2350 enumFacing) {
		if (field_11863 == null) {
			return;
		}
		field_11863.method_8501(field_11867, field_11863.method_8320(field_11867).method_11657(EnergyStorageBlock.FACING, enumFacing));
	}

	@Override
	public class_2350 getFacingEnum() {
		if (field_11863 == null) {
			return null;
		}
		class_2248 block = field_11863.method_8320(field_11867).method_26204();
		if (block instanceof EnergyStorageBlock) {
			return ((EnergyStorageBlock) block).getFacing(field_11863.method_8320(field_11867));
		}
		return null;
	}

	@Override
	public boolean canBeUpgraded() {
		return false;
	}

	// IToolDrop
	@Override
	public class_1799 getToolDrop(class_1657 entityPlayer) {
		return new class_1799(wrenchDrop);
	}

	// InventoryProvider
	@Override
	public RebornInventory<EnergyStorageBlockEntity> getInventory() {
		return inventory;
	}
}
