/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.storage.energy;

import org.jetbrains.annotations.Nullable;
import reborncore.api.blockentity.IUpgrade;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

import static techreborn.TechReborn.LOGGER;

import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11580;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_8942;
import net.minecraft.class_9135;
import net.minecraft.class_9334;

public class AdjustableSUBlockEntity extends EnergyStorageBlockEntity implements BuiltScreenHandlerProvider {

	public RebornInventory<AdjustableSUBlockEntity> inventory = new RebornInventory<>(4, "AdjustableSUBlockEntity", 64, this);
	private int OUTPUT = 64; // The current output
	public int superconductors = 0;

	public AdjustableSUBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.ADJUSTABLE_SU, pos, state, "ADJUSTABLE_SU", 4, TRContent.Machine.ADJUSTABLE_SU.block, RcEnergyTier.INSANE, TechRebornConfig.aesuMaxEnergy);
	}

	public int getMaxConfigOutput() {
		int extra = 0;
		if (superconductors > 0) {
			extra = (int) Math.pow(2, (superconductors + 2)) * maxOutput;
		}
		return maxOutput + extra;
	}

	public void handleGuiInputFromClient(int id, boolean shift, boolean ctrl) {
		if (shift) {
			id *= 4;
		}
		if (ctrl) {
			id *= 8;
		}

		OUTPUT += id;

		if (OUTPUT > getMaxConfigOutput()) {
			OUTPUT = getMaxConfigOutput();
		}
		if (OUTPUT <= 0) {
			OUTPUT = 0;
		}
	}

	// EnergyStorageBlockEntity
	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);
		if (world == null || world.method_8608()) {
			return;
		}

		if (OUTPUT > getMaxConfigOutput()) {
			OUTPUT = getMaxConfigOutput();
		}
		if (world.method_8510() % 20 == 0) {
			checkTier();
		}
	}

	@Override
	public boolean canBeUpgraded() {
		return true;
	}

	@Override
	public class_1799 getToolDrop(class_1657 entityPlayer) {
		class_1799 dropStack = TRContent.Machine.ADJUSTABLE_SU.getStack();
		if (field_11863 != null){
			try (class_8942.class_11340 logging = new class_8942.class_11340(method_71402(), LOGGER)) {
				class_11362 view = class_11362.method_71459(logging, field_11863.method_30349());
				method_11007(view);
				dropStack.method_57379(class_9334.field_49611, class_11580.method_72535(method_11017(), view.method_71475()));
			}
		}

		return dropStack;
	}

	@Override
	public long getBaseMaxOutput() {
		return OUTPUT;
	}

	@Override
	public long getBaseMaxInput() {
		// If we have super conductors increase the max input of the machine
		if (getMaxConfigOutput() > maxOutput) {
			return getMaxConfigOutput();
		}
		return maxInput;
	}

	// PowerAcceptorBlockEntity
	@Override
	public void resetUpgrades() {
		super.resetUpgrades();
		superconductors = 0;
	}

	@Override
	public long getMaxOutput(@Nullable class_2350 side) {
		return OUTPUT;
	}

	@Override
	public void method_11007(class_11372 view) {
		super.method_11007(view);
		view.method_71465("output", OUTPUT);
	}

	@Override
	public void method_11014(class_11368 view) {
		super.method_11014(view);
		this.OUTPUT = view.method_71424("output", 0);
	}

	// MachineBaseBlockEntity
	@Override
	public boolean isUpgradeValid(IUpgrade upgrade, class_1799 stack) {
		return stack.method_31574(TRContent.Upgrades.SUPERCONDUCTOR.item);
	}

	// IContainerProvider
	@Override
	public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
		return new ScreenHandlerBuilder("aesu").player(player.method_31548()).inventory().hotbar().armor()
			.complete(8, 18).addArmor().addInventory().blockEntity(this).energySlot(0, 62, 45).energySlot(1, 98, 45)
			.syncEnergyValue().sync(class_9135.field_49675, this::getCurrentOutput, this::setCurrentOutput).addInventory().create(this, syncID);
	}

	public int getCurrentOutput() {
		return OUTPUT;
	}

	public void setCurrentOutput(int output) {
		this.OUTPUT = output;
	}
}
