/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.machine.tier3;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class ChunkLoaderBlockEntity extends MachineBaseBlockEntity implements IToolDrop, InventoryProvider, BuiltScreenHandlerProvider {

	public final RebornInventory<ChunkLoaderBlockEntity> inventory = new RebornInventory<>(0, "ChunkLoaderBlockEntity", 64, this);
	private int radius;
	private String ownerUdid;

	public ChunkLoaderBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.CHUNK_LOADER, pos, state);
		this.radius = 1;
	}

	public void handleGuiInputFromClient(int buttonID, @Nullable class_1657 playerEntity) {
		radius += buttonID;

		if (radius > TechRebornConfig.chunkLoaderMaxRadius) {
			radius = TechRebornConfig.chunkLoaderMaxRadius;
		}
		if (radius <= 1) {
			radius = 1;
		}

		reload();

		if (playerEntity != null) {
			ChunkLoaderManager manager = ChunkLoaderManager.get(method_10997());
			manager.syncChunkLoaderToClient((class_3222) playerEntity, method_11016());
		}
	}

	private void reload() {
		unloadAll();
		load();
	}

	private void load() {
		ChunkLoaderManager manager = ChunkLoaderManager.get(method_10997());
		class_1923 rootPos = getChunkPos();
		int loadRadius = radius - 1;
		for (int i = -loadRadius; i <= loadRadius; i++) {
			for (int j = -loadRadius; j <= loadRadius; j++) {
				class_1923 loadPos = new class_1923(rootPos.field_9181 + i, rootPos.field_9180 + j);

				if (!manager.isChunkLoaded(method_10997(), loadPos, method_11016())) {
					manager.loadChunk(method_10997(), loadPos, method_11016(), ownerUdid);
				}
			}
		}
	}

	private void unloadAll() {
		ChunkLoaderManager manager = ChunkLoaderManager.get(field_11863);
		manager.unloadChunkLoader(field_11863, method_11016());
	}

	public class_1923 getChunkPos() {
		return new class_1923(method_11016());
	}

	// MachineBaseBlockEntity
	@Override
	public void onBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState) {
		if (world.method_8608()) {
			return;
		}
		unloadAll();
		ChunkLoaderManager.get(world).clearClient((class_3222) playerEntity);
	}

	@Override
	public void onPlace(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
		ownerUdid = placer.method_5845();
		if (worldIn.method_8608()) return;
		reload();
	}

	@Override
	public void method_11007(class_11372 view) {
		super.method_11007(view);
		view.method_71465("radius", radius);
		if (ownerUdid != null && !ownerUdid.isEmpty()){
			view.method_71469("ownerUdid", ownerUdid);
		}
		inventory.write(view);
	}

	@Override
	public void method_11014(class_11368 view) {
		super.method_11014(view);
		this.radius = view.method_71424("radius", 0);
		this.ownerUdid = view.method_71428("ownerUdid", "");
		inventory.read(view);
	}

	// IToolDrop
	@Override
	public class_1799 getToolDrop(final class_1657 entityPlayer) {
		return TRContent.Machine.CHUNK_LOADER.getStack();
	}

	// InventoryProvider
	@Override
	public RebornInventory<ChunkLoaderBlockEntity> getInventory() {
		return this.inventory;
	}

	// BuiltScreenHandlerProvider
	@Override
	public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
		return new ScreenHandlerBuilder("chunkloader").player(player.method_31548()).inventory().hotbar().addInventory()
				.blockEntity(this).sync(class_9135.field_49675, this::getRadius, this::setRadius).addInventory().create(this, syncID);
	}

	public int getRadius() {
		return radius;
	}

	public void setRadius(int radius) {
		this.radius = radius;
	}


}
