/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.machine.tier1;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_9135;
import net.minecraft.class_9902;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.WorldUtils;
import techreborn.blocks.machine.tier1.PlayerDetectorBlock;
import techreborn.blocks.machine.tier1.PlayerDetectorBlock.PlayerDetectorType;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class PlayerDetectorBlockEntity extends PowerAcceptorBlockEntity implements IToolDrop, BuiltScreenHandlerProvider {


	public String ownerUdid = "";
	boolean redstone = false;
	int radius = 16;

	public PlayerDetectorBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.PLAYER_DETECTOR, pos, state);
	}

	public boolean isProvidingPower() {
		return redstone;
	}

	public void handleGuiInputFromClient(int amount) {
		radius += amount;

		if (radius > TechRebornConfig.playerDetectorMaxRadius) {
			radius = TechRebornConfig.playerDetectorMaxRadius;
		}
		if (radius <= 1) {
			radius = 1;
		}
	}

	// PowerAcceptorBlockEntity
	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);

		if (world == null || world.method_8608()) {
			return;
		}

		if (world.method_8510() % 20 != 0) {
			return;
		}

		boolean lastRedstone = redstone;
		redstone = false;
		if (getStored() > TechRebornConfig.playerDetectorEuPerTick) {
			for (class_1657 player : world.method_18456()) {
				if (player.method_7325()){
					continue;
				}
				if (class_3532.method_15355((float)player.method_5649(pos.method_10263() +0.5f, pos.method_10264() +0.5f, pos.method_10260() +0.5f)) <= (float)radius ) {
					PlayerDetectorType type = world.method_8320(pos).method_11654(PlayerDetectorBlock.TYPE);
					if (type == PlayerDetectorType.ALL) {// ALL
						redstone = true;
					} else if (type == PlayerDetectorType.OTHERS) {// Others
						if (!ownerUdid.isEmpty() && !ownerUdid.equals(player.method_5667().toString())) {
							redstone = true;
						}
					} else {// You
						if (!ownerUdid.isEmpty() && ownerUdid.equals(player.method_5667().toString())) {
							redstone = true;
						}
					}
				}
			}
			useEnergy(TechRebornConfig.playerDetectorEuPerTick);
		}
		if (lastRedstone != redstone) {
			WorldUtils.updateBlock(world, pos);
			world.method_8452(pos, world.method_8320(pos).method_26204(), class_9902.method_61826(world, null, null));
		}
	}

	@Override
	public long getBaseMaxPower() {
		return TechRebornConfig.playerDetectorMaxEnergy;
	}

	@Override
	public boolean canProvideEnergy(@Nullable class_2350 side) {
		return false;
	}

	@Override
	public long getBaseMaxOutput() {
		return 0;
	}

	@Override
	public long getBaseMaxInput() {
		return TechRebornConfig.playerDetectorMaxInput;
	}

	@Override
	public void method_11014(class_11368 view) {
		super.method_11014(view);
		ownerUdid = view.method_71428("ownerID", "");
		radius = view.method_71424("radius", 0);
	}

	@Override
	public void method_11007(class_11372 view) {
		super.method_11007(view);
		view.method_71469("ownerID", ownerUdid);
		view.method_71465("radius", radius);
	}

	// MachineBaseBlockEntity
	@Override
	public boolean hasSlotConfig() {
		return false;
	}

	@Override
	public boolean canBeUpgraded() {
		return false;
	}

	// IToolDrop
	@Override
	public class_1799 getToolDrop(class_1657 p0) {
		return TRContent.Machine.PLAYER_DETECTOR.getStack();
	}

	// BuiltScreenHandlerProvider
	@Override
	public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
		return new ScreenHandlerBuilder("player_detector")
				.player(player.method_31548())
				.inventory().hotbar().addInventory()
				.blockEntity(this)
				.syncEnergyValue()
				.sync(class_9135.field_49675, this::getCurrentRadius, this::setCurrentRadius)
				.addInventory().create(this, syncID);
	}

	public int getCurrentRadius() {
		return radius;
	}

	public void setCurrentRadius(int radius) {
		this.radius = radius;
	}
}
