/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.machine.multiblock.casing;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.rectangular.RectangularMultiblockBlockEntityBase;
import techreborn.blocks.misc.BlockMachineCasing;
import techreborn.init.TRBlockEntities;
import techreborn.multiblocks.MultiBlockCasing;
import techreborn.utils.DirectionUtils;

public class MachineCasingBlockEntity extends RectangularMultiblockBlockEntityBase {
	private boolean firstLoad = true;

	public MachineCasingBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.MACHINE_CASINGS, pos, state);
	}

	@Override
	public void onMachineActivated() {

	}

	@Override
	public void onMachineDeactivated() {

	}

	@Override
	public MultiblockControllerBase createNewMultiblock() {
		return new MultiBlockCasing(field_11863);
	}

	@Override
	public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
		return MultiBlockCasing.class;
	}

	@Override
	public void isGoodForFrame() {

	}

	@Override
	public void isGoodForSides() {

	}

	@Override
	public void isGoodForTop() {

	}

	@Override
	public void isGoodForBottom() {

	}

	@Override
	public void isGoodForInterior() {

	}

	@Override
	public MultiBlockCasing getMultiblockController() {
		return (MultiBlockCasing) super.getMultiblockController();
	}

	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
		// Compatible with old versions
		if (firstLoad) {
			firstLoad = false;
			if (state.method_11654(DirectionUtils.HORIZONTAL_NEIGHBORS) == 0) {
				DirectionUtils.loadHorizontalNeighbors(world, pos, state, block -> block instanceof BlockMachineCasing);
			}
		}
	}
}
