/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.machine.multiblock;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.FluidValue;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class IndustrialSawmillBlockEntity extends GenericMachineBlockEntity implements BuiltScreenHandlerProvider {

	public static final FluidValue TANK_CAPACITY = FluidValue.BUCKET.multiply(16);
	public final Tank tank;
	int ticksSinceLastChange;

	public IndustrialSawmillBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.INDUSTRIAL_SAWMILL, pos, state, "IndustrialSawmill", TechRebornConfig.industrialSawmillMaxInput, TechRebornConfig.industrialSawmillMaxEnergy, TRContent.Machine.INDUSTRIAL_SAWMILL.block, 6);
		final int[] inputs = new int[]{0, 1};
		final int[] outputs = new int[]{2, 3, 4};
		this.inventory = new RebornInventory<>(7, "SawmillBlockEntity", 64, this);
		this.crafter = new RecipeCrafter(ModRecipes.INDUSTRIAL_SAWMILL, this, 1, 3, this.inventory, inputs, outputs);
		this.tank = new Tank("SawmillBlockEntity", IndustrialSawmillBlockEntity.TANK_CAPACITY);
		this.ticksSinceLastChange = 0;
	}

	@Override
	public boolean hasMultiblock() {
		return true;
	}

	@Override
	public void writeMultiblock(MultiblockWriter writer) {
		class_2248 basic = TRContent.MachineBlocks.BASIC.getCasing();
		class_2248 advanced = TRContent.MachineBlocks.ADVANCED.getCasing();
		writer.translate(1, -1, -1)
				.fill(0, 0, 0, 3, 1, 3, basic)
				.ring(class_2350.class_2351.field_11052, 3, 1, 3, (view, pos) -> view.method_8320(pos).method_27852(advanced), advanced.method_9564(), (view, pos) -> view.method_8320(pos).method_26204() == class_2246.field_10382, class_2246.field_10382.method_9564())
				.fill(0, 2, 0, 3, 3, 3, basic);
	}

	// TileGenericMachine
	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);
		if (world == null || world.method_8608()) {
			return;
		}

		ticksSinceLastChange++;
		// Check cells input slot 2 time per second
		if (ticksSinceLastChange >= 10) {
			if (!inventory.method_5438(1).method_7960()) {
				FluidUtils.drainContainers(tank, inventory, 1, 5);
				FluidUtils.fillContainers(tank, inventory, 1, 5);
			}
			ticksSinceLastChange = 0;
		}
	}

	// TilePowerAcceptor
	@Override
	public void method_11014(class_11368 view) {
		super.method_11014(view);
		tank.read(view);
	}

	@Override
	public void method_11007(class_11372 view) {
		super.method_11007(view);
		tank.write(view);
	}

	// TileMachineBase
	@Nullable
	@Override
	public Tank getTank() {
		return tank;
	}

	// IContainerProvider
	@Override
	public BuiltScreenHandler createScreenHandler(int syncID, final class_1657 player) {
		return new ScreenHandlerBuilder("industrialsawmill").player(player.method_31548()).inventory().hotbar().addInventory()
				.blockEntity(this).fluidSlot(1, 34, 35).slot(0, 84, 43).outputSlot(2, 126, 25).outputSlot(3, 126, 43)
				.outputSlot(4, 126, 61).outputSlot(5, 34, 55).energySlot(6, 8, 72).sync(tank).syncEnergyValue().syncCrafterValue().syncShapeValue()
				.addInventory().create(this, syncID);
	}

}
