/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.machine.misc;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5553;
import net.minecraft.class_5556;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.util.Tank;
import techreborn.TechReborn;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class DrainBlockEntity extends MachineBaseBlockEntity implements IToolDrop {

	protected final Tank internalTank = new Tank("tank", FluidValue.BUCKET);

	public DrainBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.DRAIN, pos, state);
	}

	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);
		if (world == null || world.method_8608()) {
			return;
		}

		int ticks = TechRebornConfig.ticksUntilNextDrainAttempt;
		if (ticks > 0 && world.method_8510() % ticks == 0) {

			if (internalTank.isEmpty()) {
				tryDrain();
			}
		}
	}

	@Nullable
	@Override
	public Tank getTank() {
		return internalTank;
	}

	private void tryDrain() {
		// Position above drain
		class_2338 above = this.method_11016().method_10084();

		// Block and state above drain
		class_2680 aboveBlockState = field_11863.method_8320(above);
		class_2248 aboveBlock = aboveBlockState.method_26204();

		if (aboveBlock instanceof class_2263) {
			class_1799 fluidContainer = ((class_2263) aboveBlock).method_9700(null, field_11863, above, aboveBlockState);
			if (fluidContainer.method_7909() instanceof ItemFluidInfo) {
				class_3611 drainFluid = ((ItemFluidInfo) fluidContainer.method_7909()).getFluid(fluidContainer);
				internalTank.setFluidInstance(new FluidInstance(drainFluid, FluidValue.BUCKET));
			} else {
				TechReborn.LOGGER.debug("Could not get Fluid from ItemStack " + fluidContainer.method_7909());
			}
		}
		if (aboveBlock instanceof class_5556 && aboveBlockState.method_27852(class_2246.field_27097)) { //ensure Water cauldron
			class_3611 drainFluid = class_3612.field_15910;
			int fluidLevel;
			if (aboveBlockState.method_28498(class_5556.field_27206)){
				fluidLevel = aboveBlockState.method_11654(class_5556.field_27206);
			}
			else {
				return;
			}
			field_11863.method_8501(above, class_2246.field_10593.method_9564());
			internalTank.setFluidInstance(
				new FluidInstance(drainFluid, FluidValue.BUCKET.fraction(3).multiply(fluidLevel))
			);
		}
		if (aboveBlock instanceof class_5553){
			field_11863.method_8501(above, class_2246.field_10593.method_9564());
			internalTank.setFluidInstance(
				new FluidInstance(class_3612.field_15908, FluidValue.BUCKET)
			);
		}
	}

	@Override
	public class_1799 getToolDrop(class_1657 p0) {
		return TRContent.Machine.DRAIN.getStack();
	}

	@Override
	public void method_11007(class_11372 view) {
		super.method_11007(view);
		internalTank.write(view);
	}

	@Override
	public void method_11014(class_11368 view) {
		super.method_11014(view);
		internalTank.read(view);
	}
}
