/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.machine.misc;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5558;
import reborncore.api.IToolDrop;
import techreborn.blocks.misc.BlockAlarm;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class AlarmBlockEntity extends class_2586
		implements class_5558<AlarmBlockEntity>, IToolDrop {
	private int selectedSound = 1;

	public AlarmBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.ALARM, pos, state);
	}

	public void rightClick(class_1297 entity) {
		if (field_11863 == null) return;

		if (selectedSound < 3) {
			selectedSound++;
		} else {
			selectedSound = 1;
		}

		if (entity instanceof class_3222 serverPlayerEntity) {
			serverPlayerEntity.method_7353(class_2561.method_43471("techreborn.message.alarm")
											.method_27692(class_124.field_1080)
											.method_27693(" Alarm ")
											.method_27693(String.valueOf(selectedSound)), true);
		}
	}

	// BlockEntity
	@Override
	public void method_11007(class_11372 view) {
		super.method_11007(view);
		view.method_71465("selectedSound", this.selectedSound);
	}

	@Override
	public void method_11014(class_11368 view) {
		super.method_11014(view);
		selectedSound = view.method_71424("selectedSound", 0);
	}

	// Tickable
	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, AlarmBlockEntity blockEntity) {
		if (world == null || world.method_8608()) return;
		if (world.method_8510() % 25 != 0) return;

		if (world.method_49803(method_11016())) {
			BlockAlarm.setActive(true, world, pos);
			switch (selectedSound) {
				case 1 -> world.method_43128(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), ModSounds.ALARM, class_3419.field_15245, 4F, 1F);
				case 2 -> world.method_43128(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), ModSounds.ALARM_2, class_3419.field_15245, 4F, 1F);
				case 3 -> world.method_43128(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), ModSounds.ALARM_3, class_3419.field_15245, 4F, 1F);
			}
		} else {
			BlockAlarm.setActive(false, world, pos);
		}
	}

	// IToolDrop
	@Override
	public class_1799 getToolDrop(final class_1657 entityPlayer) {
		return TRContent.Machine.ALARM.getStack();
	}
}
