/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.lighting;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import techreborn.blocks.lighting.LampBlock;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class LampBlockEntity extends PowerAcceptorBlockEntity implements IToolDrop {

	private static final int capacity = 33;

	public LampBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.LAMP, pos, state);
	}

	// PowerAcceptorBlockEntity
	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);
		if (world == null || world.method_8608()) {
			return;
		}
		class_2248 b = state.method_26204();
		if (!(b instanceof LampBlock)) {
			return;
		}

		long cost = getEuPerTick(((LampBlock) b).getCost());
		if (getStored() > cost) {
			useEnergy(cost);
			if (!LampBlock.isActive(state)) {
				LampBlock.setActive(true, world, pos);
			}
		} else if (LampBlock.isActive(state)) {
			LampBlock.setActive(false, world, pos);
		}
	}

	@Override
	protected boolean canAcceptEnergy(@Nullable class_2350 side) {
		return side == null || getFacing().method_10153() == class_2350.values()[side.ordinal()];
	}

	@Override
	public boolean canProvideEnergy(@Nullable class_2350 side) {
		return false;
	}

	@Override
	public long getBaseMaxPower() {
		return capacity;
	}

	@Override
	public long getBaseMaxOutput() {
		return 0;
	}

	@Override
	public long getBaseMaxInput() {
		return 32;
	}

	// MachineBaseBlockEntity
	@Override
	public class_2350 getFacing(){
		if (field_11863 == null){
			return class_2350.field_11043;
		}
		return LampBlock.getFacing(field_11863.method_8320(field_11867));
	}

	// IToolDrop
	@Override
	public class_1799 getToolDrop(final class_1657 entityPlayer) {
		// I know it is weird. But world is nullable
		if (field_11863 == null) {
			return new class_1799(TRContent.Machine.LAMP_INCANDESCENT.block);
		}
		return new class_1799(field_11863.method_8320(field_11867).method_26204());
	}
}
