/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.generator.advanced;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class DragonEggSyphonBlockEntity extends PowerAcceptorBlockEntity
		implements IToolDrop, InventoryProvider {

	public final RebornInventory<DragonEggSyphonBlockEntity> inventory = new RebornInventory<>(3, "DragonEggSyphonBlockEntity", 64, this);
	private long lastOutput = 0;

	public DragonEggSyphonBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.DRAGON_EGG_SYPHON, pos, state);
	}

	private boolean tryAddingEnergy(int amount) {
		if (getFreeSpace() > 0) {
			addEnergy(amount);
			return true;
		}

		return false;
	}

	// PowerAcceptorBlockEntity
	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);
		if (world == null || world.method_8608()) {
			return;
		}

		if (world.method_8320(new class_2338(pos.method_10263(), pos.method_10264() + 1, pos.method_10260()))
				.method_26204() == class_2246.field_10081) {
			if (tryAddingEnergy(TechRebornConfig.dragonEggSyphonEnergyPerTick))
				lastOutput = world.method_8510();
		}

		if (world.method_8510() - lastOutput < 30 && !isActive()) {
			world.method_8501(pos, world.method_8320(pos).method_11657(BlockMachineBase.ACTIVE, true));
		} else if (world.method_8510() - lastOutput > 30 && isActive()) {
			world.method_8501(pos, world.method_8320(pos).method_11657(BlockMachineBase.ACTIVE, false));
		}
	}

	@Override
	public long getBaseMaxPower() {
		return TechRebornConfig.dragonEggSyphonMaxEnergy;
	}

	@Override
	public boolean canAcceptEnergy(@Nullable class_2350 side) {
		return false;
	}

	@Override
	public long getBaseMaxOutput() {
		return TechRebornConfig.dragonEggSyphonMaxOutput;
	}

	@Override
	public long getBaseMaxInput() {
		return 0;
	}

	// IToolDrop
	@Override
	public class_1799 getToolDrop(class_1657 entityPlayer) {
		return TRContent.Machine.DRAGON_EGG_SYPHON.getStack();
	}

	// InventoryProvider
	@Override
	public RebornInventory<DragonEggSyphonBlockEntity> getInventory() {
		return inventory;
	}
}
