/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blockentity.generator;

import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3730;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class LightningRodBlockEntity extends PowerAcceptorBlockEntity implements IToolDrop {


	private int onStatusHoldTicks = -1;

	public LightningRodBlockEntity(class_2338 pos, class_2680 state) {
		super(TRBlockEntities.LIGHTNING_ROD, pos, state);
	}

	@Override
	public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
		super.tick(world, pos, state, blockEntity);
		if (world == null || world.method_8608()){
			return;
		}

		if (onStatusHoldTicks > 0) {
			--onStatusHoldTicks;
		}

		class_2248 BEBlock = method_11010().method_26204();
		if (!(BEBlock instanceof BlockMachineBase machineBaseBlock)) {
			return;
		}

		if (onStatusHoldTicks == 0 || getEnergy() <= 0) {
			machineBaseBlock.setActive(false, world, pos);
			onStatusHoldTicks = -1;
		}

		final float weatherStrength = world.method_8478(1.0F);
		if (weatherStrength > 0.2F) {
			//lightStrikeChance = (MAX - (CHANCE * WEATHER_STRENGTH)
			final float lightStrikeChance = (100F - TechRebornConfig.lightningRodChanceOfStrike) * 20F;
			final float totalChance = lightStrikeChance * getLightningStrikeMultiplier() * (1.1F - weatherStrength);
			if (world.field_9229.method_43048((int) Math.floor(totalChance)) == 0) {
				if (!isValidIronFence(pos.method_10084().method_10264())) {
					onStatusHoldTicks = 400;
					return;
				}

				class_1538 lightningBolt = class_1299.field_6112.method_5883(world, class_3730.field_16461);
				lightningBolt.method_29495(class_243.method_24955(world.method_8598(class_2902.class_2903.field_13197, method_11016())));
				world.method_8649(lightningBolt);
				addEnergy((long) (TechRebornConfig.lightningRodBaseEnergyStrike * (0.3F + weatherStrength)));
				machineBaseBlock.setActive(true, world, pos);
				onStatusHoldTicks = 400;
			}
		}

	}

	public float getLightningStrikeMultiplier() {
		final float actualHeight = field_11863.method_31600();
		final float groundLevel = field_11863.method_8615() + 1;
		for (int i = field_11867.method_10264() + 1; i < actualHeight; i++) {
			if (!isValidIronFence(i)) {
				if (groundLevel >= i)
					return 4.3F;
				final float max = actualHeight - groundLevel;
				final float got = i - groundLevel;
				return 1.2F - got / max;
			}
		}
		return 0.2F;
	}

	public boolean isValidIronFence(int y) {
		if (field_11863 == null){
			return false;
		}
		class_2248 block = this.field_11863.method_8320(new class_2338(field_11867.method_10263(), y, field_11867.method_10260())).method_26204();
		return block == TRContent.REFINED_IRON_FENCE;
	}

	@Override
	public long getBaseMaxPower() {
		return TechRebornConfig.lightningRodMaxEnergy;
	}

	@Override
	public boolean canAcceptEnergy(@Nullable class_2350 side) {
		return false;
	}

	@Override
	public long getBaseMaxOutput() {
		return TechRebornConfig.lightningRodMaxOutput;
	}

	@Override
	public long getBaseMaxInput() {
		return 0;
	}

	@Override
	public class_1799 getToolDrop(class_1657 playerIn) {
		return TRContent.Machine.LIGHTNING_ROD.getStack();
	}
}
