/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_10443;
import net.minecraft.class_10493;
import net.minecraft.class_11515;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5616;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import reborncore.client.ClientJumpEvent;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.element.MachineFaceElementRenderer;
import reborncore.client.multiblock.MultiblockRenderer;
import techreborn.client.ClientGuiType;
import techreborn.client.ClientboundPacketHandlers;
import techreborn.client.events.ClientJumpHandler;
import techreborn.client.events.StackToolTipHandler;
import techreborn.client.keybindings.KeyBindings;
import techreborn.client.render.*;
import techreborn.client.render.entitys.CableCoverRenderer;
import techreborn.client.render.entitys.NukeRenderer;
import techreborn.client.render.entitys.StorageUnitRenderer;
import techreborn.client.render.entitys.TurbineRenderer;
import techreborn.init.ModFluids;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;
import techreborn.items.DynamicCellItem;

import java.util.Arrays;

public class TechRebornClient implements ClientModInitializer {

	@Override
	public void onInitializeClient() {
		ModelLoadingPlugin.register((pluginContext) -> {
			for (TRContent.MachineBlocks block : TRContent.MachineBlocks.values()) {
				pluginContext.registerBlockStateResolver(block.casing, MachineCasingModel::resolveBlockStates);
			}
		});
		class_10443.field_55336.method_65325(ItemCellModel.ID, ItemCellModel.Unbaked.CODEC);
		class_10443.field_55336.method_65325(ItemBucketModel.ID, ItemBucketModel.Unbaked.CODEC);
		class_10493.field_55421.method_65325(ActiveProperty.ID, ActiveProperty.TYPE);

		KeyBindings.registerKeys();

		ClientTickEvents.END_CLIENT_TICK.register(client -> {
			while (KeyBindings.suitNightVision.method_1436()) {
				KeyBindings.handleSuitNVToggle();
			}
		});

		ClientTickEvents.END_CLIENT_TICK.register(client -> {
			while (KeyBindings.quantumSuitSprint.method_1436()) {
				KeyBindings.handleQuantumSuitSprintToggle();
			}
		});

		StackToolTipHandler.setup();
		ClientboundPacketHandlers.init();

		GuiBase.wrenchStack = new class_1799(TRContent.WRENCH);
		GuiBase.fluidCellProvider = DynamicCellItem::getCellWithFluid;

		Arrays.stream(TRContent.Cables.values()).forEach(cable -> BlockRenderLayerMap.putBlock(cable.block, class_11515.field_60925));

		BlockRenderLayerMap.putBlock(TRContent.Machine.LAMP_INCANDESCENT.block, class_11515.field_60925);
		BlockRenderLayerMap.putBlock(TRContent.Machine.LAMP_LED.block, class_11515.field_60925);
		BlockRenderLayerMap.putBlock(TRContent.Machine.ALARM.block, class_11515.field_60925);
		BlockRenderLayerMap.putBlock(TRContent.RUBBER_SAPLING, class_11515.field_60925);
		BlockRenderLayerMap.putBlock(TRContent.REINFORCED_GLASS, class_11515.field_60925);
		BlockRenderLayerMap.putBlock(TRContent.Machine.RESIN_BASIN.block, class_11515.field_60925);
		BlockRenderLayerMap.putBlock(TRContent.POTTED_RUBBER_SAPLING, class_11515.field_60925);
		BlockRenderLayerMap.putBlock(TRContent.Machine.FISHING_STATION.block, class_11515.field_60925);

		BlockRenderLayerMap.putBlock(TRContent.RUBBER_LEAVES, class_11515.field_60924);

		for (ModFluids fluid : ModFluids.values()) {
			BlockRenderLayerMap.putFluid(fluid.getFluid(), class_11515.field_60926);
			BlockRenderLayerMap.putFluid(fluid.getFlowingFluid(), class_11515.field_60926);
		}

		class_5616.method_32144(TRBlockEntities.INDUSTRIAL_GRINDER, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.FUSION_CONTROL_COMPUTER, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.INDUSTRIAL_BLAST_FURNACE, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.VACUUM_FREEZER, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.FLUID_REPLICATOR, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.INDUSTRIAL_SAWMILL, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.DISTILLATION_TOWER, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.IMPLOSION_COMPRESSOR, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.GREENHOUSE_CONTROLLER, MultiblockRenderer::new);
		class_5616.method_32144(TRBlockEntities.STORAGE_UNIT, StorageUnitRenderer::new);
		class_5616.method_32144(TRBlockEntities.CABLE, CableCoverRenderer::new);
		class_5616.method_32144(TRBlockEntities.WIND_MILL, TurbineRenderer::new);

		EntityRendererRegistry.register(TRContent.ENTITY_NUKE, NukeRenderer::new);

		ClientGuiType.AESU.toString();

		ClientJumpEvent.EVENT.register(new ClientJumpHandler());

		// Skip error sprite
		MachineFaceElementRenderer.BLACKLIST.add(class_2960.method_60655("techreborn", "block/machines/tier2_machines/fishing_station_net"));
		MachineFaceElementRenderer.BLACKLIST.add(class_2960.method_60655("techreborn", "block/machines/tier2_machines/fishing_station_net_side"));
	}

	//Need the item instance in a few places, this makes it easier
	private interface ItemModelPredicateProvider<T extends class_1792> {

		float call(T item, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed);

		default float unclampedCall(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
			//noinspection unchecked
			return call((T) stack.method_7909(), stack, world, entity, seed);
		}

	}
}
