/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;
import reborncore.RebornCore;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.crafting.SizedIngredient;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.recipes.ICrafterSoundHandler;
import reborncore.common.recipes.IUpgradeHandler;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;

public class RecipeCrafter
implements IUpgradeHandler {
    public class_3956<? extends RebornRecipe> recipeType;
    public class_2586 blockEntity;
    public PowerAcceptorBlockEntity energy;
    public Optional<IUpgradeHandler> parentUpgradeHandler = Optional.empty();
    public int inputs;
    public int outputs;
    public RebornInventory<?> inventory;
    public int[] inputSlots;
    public int[] outputSlots;
    public RebornRecipe currentRecipe;
    public long lastSoundTime = 0L;
    private long cachedWorldTime = 0L;
    public int currentTickTime = 0;
    public int currentNeededTicks = 1;
    int ticksSinceLastChange;
    @Nullable
    public static ICrafterSoundHandler soundHandler = (firstRun, blockEntity) -> {};

    public RecipeCrafter(class_3956<? extends RebornRecipe> recipeType, class_2586 blockEntity, int inputs, int outputs, RebornInventory<?> inventory, int[] inputSlots, int[] outputSlots) {
        this.recipeType = recipeType;
        this.blockEntity = blockEntity;
        if (blockEntity instanceof PowerAcceptorBlockEntity) {
            PowerAcceptorBlockEntity powerAcceptor;
            this.energy = powerAcceptor = (PowerAcceptorBlockEntity)blockEntity;
        }
        if (blockEntity instanceof IUpgradeHandler) {
            this.parentUpgradeHandler = Optional.of((IUpgradeHandler)blockEntity);
        }
        this.inputs = inputs;
        this.outputs = outputs;
        this.inventory = inventory;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        if (!(blockEntity instanceof IRecipeCrafterProvider)) {
            RebornCore.LOGGER.error(blockEntity.getClass().getName() + " does not use IRecipeCrafterProvider report this to the issue tracker!");
        }
    }

    public void updateEntity() {
        if (this.blockEntity.method_10997() == null || this.blockEntity.method_10997().method_8608()) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.cachedWorldTime == 0L) {
            this.cachedWorldTime = this.blockEntity.method_10997().method_8510();
        }
        ++this.cachedWorldTime;
        if (this.ticksSinceLastChange == 20) {
            this.setInvDirty(true);
            this.ticksSinceLastChange = 0;
            this.setIsActive();
        }
        if (this.currentRecipe == null && this.isInvDirty()) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipe != null) {
            long useRequirement;
            if (this.isInvDirty() && !this.hasAllInputs() || this.energy.hasMultiblock() && !this.energy.isShapeValid()) {
                this.currentRecipe = null;
                this.currentTickTime = 0;
                this.setIsActive();
            }
            if (this.currentRecipe != null && this.currentTickTime >= this.currentNeededTicks && this.hasAllInputs()) {
                List<class_1799> outputs = this.currentRecipe.outputs();
                boolean canGiveInvAll = true;
                for (int i = 0; i < outputs.size(); ++i) {
                    if (this.canFitOutput(outputs.get(i), this.outputSlots[i])) continue;
                    canGiveInvAll = false;
                }
                ArrayList<Integer> filledSlots = new ArrayList<Integer>();
                if (canGiveInvAll && this.currentRecipe.onCraft(this.blockEntity)) {
                    for (int i = 0; i < outputs.size(); ++i) {
                        if (filledSlots.contains(this.outputSlots[i])) continue;
                        this.fitStack(outputs.get(i).method_7972(), this.outputSlots[i]);
                        filledSlots.add(this.outputSlots[i]);
                    }
                    this.useAllInputs();
                    this.currentRecipe = null;
                    this.currentTickTime = 0;
                    this.updateCurrentRecipe();
                    if (this.currentRecipe == null) {
                        this.setIsActive();
                    }
                }
            } else if (this.currentRecipe != null && this.currentTickTime < this.currentNeededTicks && this.energy.tryUseExact(useRequirement = this.getEuPerTick(this.currentRecipe.power()))) {
                ++this.currentTickTime;
                if ((this.currentTickTime == 1 || this.currentTickTime % 20 == 0 && this.cachedWorldTime > this.lastSoundTime + 10L) && soundHandler != null && !this.isMuffled()) {
                    this.lastSoundTime = this.cachedWorldTime;
                    soundHandler.playSound(false, this.blockEntity);
                }
            }
        }
        this.setInvDirty(false);
    }

    public void updateCurrentRecipe() {
        this.currentTickTime = 0;
        for (RebornRecipe rebornRecipe : RecipeUtils.getRecipes(this.blockEntity.method_10997(), this.recipeType)) {
            if (!this.hasAllInputs(rebornRecipe) || !rebornRecipe.canCraft(this.blockEntity)) continue;
            List<class_1799> outputs = rebornRecipe.outputs();
            boolean hasOutputSpace = true;
            for (int i = 0; i < outputs.size(); ++i) {
                if (this.canFitOutput(outputs.get(i), this.outputSlots[i])) continue;
                hasOutputSpace = false;
            }
            if (!hasOutputSpace) continue;
            this.setCurrentRecipe(rebornRecipe);
            this.currentNeededTicks = Math.max((int)((double)this.currentRecipe.time() * (1.0 - this.getSpeedMultiplier())), 1);
            this.setIsActive();
            return;
        }
        this.setCurrentRecipe(null);
        this.currentNeededTicks = 0;
        this.setIsActive();
    }

    public boolean hasAllInputs() {
        return this.hasAllInputs(this.currentRecipe);
    }

    public boolean hasAllInputs(RebornRecipe recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (SizedIngredient ingredient : recipeType.ingredients()) {
            boolean hasItem = false;
            for (int slot : this.inputSlots) {
                if (!ingredient.test(this.inventory.method_5438(slot))) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    public void useAllInputs() {
        if (this.currentRecipe == null) {
            return;
        }
        block0: for (SizedIngredient ingredient : this.currentRecipe.ingredients()) {
            for (int inputSlot : this.inputSlots) {
                if (!ingredient.test(this.inventory.method_5438(inputSlot))) continue;
                this.inventory.shrinkSlot(inputSlot, ingredient.count());
                continue block0;
            }
        }
    }

    public boolean canFitOutput(class_1799 stack, int slot) {
        if (stack.method_7960()) {
            return true;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual(this.inventory.method_5438(slot), stack, true, true)) {
            return stack.method_7947() + this.inventory.method_5438(slot).method_7947() <= stack.method_7914();
        }
        return false;
    }

    public void fitStack(class_1799 stack, int slot) {
        if (stack.method_7960()) {
            return;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            this.inventory.method_5447(slot, stack);
            return;
        }
        if (class_1799.method_31577((class_1799)this.inventory.method_5438(slot), (class_1799)stack) && stack.method_7947() + this.inventory.method_5438(slot).method_7947() <= stack.method_7914()) {
            class_1799 newStack = stack.method_7972();
            newStack.method_7939(this.inventory.method_5438(slot).method_7947() + stack.method_7947());
            this.inventory.method_5447(slot, newStack);
        }
    }

    public void read(class_11368 view) {
        view.method_71420("Crater").ifPresent(data -> {
            this.currentTickTime = data.method_71424("currentTickTime", 0);
        });
        if (this.blockEntity != null && this.blockEntity.method_10997() != null && this.blockEntity.method_10997().method_8608()) {
            this.blockEntity.method_10997().method_8413(this.blockEntity.method_11016(), this.blockEntity.method_10997().method_8320(this.blockEntity.method_11016()), this.blockEntity.method_10997().method_8320(this.blockEntity.method_11016()), 3);
        }
    }

    public void write(class_11372 view) {
        view.method_71461("Crater").method_71463("currentTickTime", (double)this.currentTickTime);
    }

    private boolean isActive() {
        return this.currentRecipe != null && this.energy.getEnergy() >= (long)this.currentRecipe.power();
    }

    public boolean canCraftAgain() {
        for (RebornRecipe rebornRecipe : RecipeUtils.getRecipes(this.blockEntity.method_10997(), this.recipeType)) {
            if (!rebornRecipe.canCraft(this.blockEntity) || !this.hasAllInputs(rebornRecipe)) continue;
            List<class_1799> outputs = rebornRecipe.outputs();
            for (int i = 0; i < outputs.size(); ++i) {
                if (this.canFitOutput(outputs.get(i), this.outputSlots[i])) continue;
                return false;
            }
            return this.energy.getEnergy() >= (long)rebornRecipe.power();
        }
        return false;
    }

    public void setIsActive() {
        class_2338 pos = this.blockEntity.method_11016();
        if (this.blockEntity.method_10997() == null) {
            return;
        }
        class_2680 oldState = this.blockEntity.method_10997().method_8320(pos);
        class_2248 class_22482 = oldState.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            boolean isActive;
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            boolean bl = isActive = this.isActive() || this.canCraftAgain();
            if (isActive == (Boolean)oldState.method_11654((class_2769)BlockMachineBase.ACTIVE)) {
                return;
            }
            blockMachineBase.setActive(isActive, this.blockEntity.method_10997(), pos);
            this.blockEntity.method_10997().method_8413(pos, oldState, this.blockEntity.method_10997().method_8320(pos), 3);
        }
    }

    public void setCurrentRecipe(RebornRecipe recipe) {
        this.currentRecipe = recipe;
    }

    public boolean isInvDirty() {
        return this.inventory.hasChanged();
    }

    public void setInvDirty(boolean isDirty) {
        this.inventory.setHashChanged(isDirty);
    }

    public boolean isStackValidInput(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1799 largeStack = stack.method_7972();
        largeStack.method_7939(largeStack.method_7914());
        for (RebornRecipe rebornRecipe : RecipeUtils.getRecipes(this.blockEntity.method_10997(), this.recipeType)) {
            for (SizedIngredient ingredient : rebornRecipe.ingredients()) {
                if (!ingredient.test(largeStack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void resetSpeedMultiplier() {
        this.parentUpgradeHandler.ifPresent(IUpgradeHandler::resetSpeedMultiplier);
    }

    @Override
    public double getSpeedMultiplier() {
        return Math.min(this.parentUpgradeHandler.map(IUpgradeHandler::getSpeedMultiplier).orElse(0.0), 0.99);
    }

    @Override
    public void addPowerMultiplier(double amount) {
        this.parentUpgradeHandler.ifPresent(iUpgradeHandler -> iUpgradeHandler.addPowerMultiplier(amount));
    }

    @Override
    public void resetPowerMultiplier() {
        this.parentUpgradeHandler.ifPresent(IUpgradeHandler::resetPowerMultiplier);
    }

    @Override
    public double getPowerMultiplier() {
        return this.parentUpgradeHandler.map(IUpgradeHandler::getPowerMultiplier).orElse(1.0);
    }

    @Override
    public long getEuPerTick(long baseEu) {
        long power = this.parentUpgradeHandler.map(iUpgradeHandler -> iUpgradeHandler.getEuPerTick(baseEu)).orElse(1L);
        return Math.min(power, this.energy.getMaxStoredPower());
    }

    @Override
    public void addSpeedMultiplier(double amount) {
        this.parentUpgradeHandler.ifPresent(iUpgradeHandler -> iUpgradeHandler.addSpeedMultiplier(amount));
    }

    @Override
    public void muffle() {
        this.parentUpgradeHandler.ifPresent(IUpgradeHandler::muffle);
    }

    @Override
    public void resetMuffler() {
        this.parentUpgradeHandler.ifPresent(IUpgradeHandler::resetMuffler);
    }

    @Override
    public boolean isMuffled() {
        return this.parentUpgradeHandler.map(IUpgradeHandler::isMuffled).orElse(false);
    }

    @Nullable
    private class_5455 getDynamicRegistryManager() {
        return this.blockEntity.method_10997().method_30349();
    }
}

