/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blocks;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import reborncore.api.ToolManager;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.util.ItemHandlerUtils;
import reborncore.common.util.Tank;
import reborncore.common.util.WrenchUtils;

public abstract class BlockMachineBase
extends BaseBlockEntityProvider
implements class_3954 {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    boolean hasCustomStates;

    public BlockMachineBase(class_4970.class_2251 builder) {
        this(builder, false);
    }

    public BlockMachineBase(class_4970.class_2251 builder, boolean hasCustomStates) {
        super(builder);
        this.hasCustomStates = hasCustomStates;
        if (!hasCustomStates) {
            this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
        BlockWrenchEventHandler.wrenchableBlocks.add(this);
    }

    public void setFacing(class_2350 facing, class_1937 world, class_2338 pos) {
        if (this.hasCustomStates) {
            return;
        }
        world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657(FACING, (Comparable)facing));
    }

    public class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654(FACING);
    }

    public void setActive(Boolean active, class_1937 world, class_2338 pos) {
        if (this.hasCustomStates) {
            return;
        }
        class_2350 facing = (class_2350)world.method_8320(pos).method_11654(FACING);
        class_2680 state = (class_2680)((class_2680)world.method_8320(pos).method_11657((class_2769)ACTIVE, (Comparable)active)).method_11657(FACING, (Comparable)facing);
        world.method_8652(pos, state, 3);
    }

    public boolean isActive(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)ACTIVE);
    }

    public boolean isAdvanced() {
        return false;
    }

    public abstract IMachineGuiHandler getGui();

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        this.setFacing(placer.method_5735().method_10153(), worldIn, pos);
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity instanceof MachineBaseBlockEntity) {
            ((MachineBaseBlockEntity)blockEntity).onPlace(worldIn, pos, state, placer, stack);
        }
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ACTIVE});
    }

    protected void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
        ItemHandlerUtils.dropContainedItems((class_1937)worldIn, pos);
        super.method_66388(state, worldIn, pos, isMoving);
    }

    public class_2680 method_9576(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 playerEntity) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof MachineBaseBlockEntity) {
            ((MachineBaseBlockEntity)blockEntity).onBreak(world, playerEntity, blockPos, blockState);
        }
        return super.method_9576(world, blockPos, blockState, playerEntity);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return class_1703.method_7618((class_1263)this.method_17680(state, (class_1936)world, pos));
    }

    public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {
        Tank tank;
        class_1799 stack = playerIn.method_5998(class_1268.field_5808);
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity == null) {
            return class_1269.field_5811;
        }
        if (blockEntity instanceof MachineBaseBlockEntity && (tank = ((MachineBaseBlockEntity)blockEntity).getTank()) != null && FluidUtils.interactWithFluidHandler(playerIn, tank)) {
            return class_1269.field_5812;
        }
        if (!stack.method_7960()) {
            int inserted;
            IUpgradeable upgradeableEntity;
            if (ToolManager.INSTANCE.canHandleTool(stack)) {
                if (WrenchUtils.handleWrench(stack, worldIn, pos, playerIn, hitResult.method_17780())) {
                    return class_1269.field_5812;
                }
            } else if (stack.method_7909() instanceof IUpgrade && blockEntity instanceof IUpgradeable && (upgradeableEntity = (IUpgradeable)blockEntity).canBeUpgraded() && (inserted = (int)BlockMachineBase.insertItemStacked(InventoryStorage.of((class_1263)upgradeableEntity.getUpgradeInventory(), null), ItemVariant.of((class_1799)stack), stack.method_7947())) > 0) {
                stack.method_7934(inserted);
                return class_1269.field_5812;
            }
        }
        if (this.getGui() != null && !playerIn.method_5715()) {
            this.getGui().open(playerIn, pos, worldIn);
            return class_1269.field_5812;
        }
        return super.method_55766(state, worldIn, pos, playerIn, hitResult);
    }

    public static long insertItemStacked(InventoryStorage inventory, ItemVariant variant, long maxAmount) {
        long inserted = 0L;
        try (Transaction tx = Transaction.openOuter();){
            block5: for (int loop = 0; loop < 2; ++loop) {
                for (SingleSlotStorage slot : inventory.getSlots()) {
                    if (!((ItemVariant)slot.getResource()).equals((Object)variant) && loop != 1 || (inserted += slot.insert((Object)variant, maxAmount - inserted, (TransactionContext)tx)) != maxAmount) continue;
                    break block5;
                }
            }
            tx.commit();
        }
        return inserted;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_1278 method_17680(class_2680 blockState, class_1936 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof MachineBaseBlockEntity) {
            return (MachineBaseBlockEntity)blockEntity;
        }
        return null;
    }
}

