/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import reborncore.RebornCore;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.NBTSerializable;
import reborncore.common.util.RebornInventory;

public class SlotConfiguration
implements NBTSerializable {
    public static final class_9139<ByteBuf, SlotConfiguration> PACKET_CODEC = SlotConfigHolder.PACKET_CODEC.method_56433(class_9135.method_56363()).method_56432(SlotConfiguration::new, SlotConfiguration::getSlotDetails);
    List<SlotConfigHolder> slotDetails = new ArrayList<SlotConfigHolder>();
    @Nullable
    class_1263 inventory;

    public SlotConfiguration(RebornInventory<?> inventory) {
        this.inventory = inventory;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            this.updateSlotDetails(new SlotConfigHolder(i));
        }
    }

    private SlotConfiguration(List<SlotConfigHolder> slotDetails) {
        this.slotDetails = slotDetails;
        this.inventory = null;
    }

    public void update(MachineBaseBlockEntity machineBase) {
        if (this.inventory == null && machineBase.getOptionalInventory().isPresent()) {
            this.inventory = machineBase.getOptionalInventory().get();
        }
        if (this.inventory != null && this.slotDetails.size() != this.inventory.method_5439()) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                SlotConfigHolder holder = this.getSlotDetails(i);
                if (holder != null) continue;
                RebornCore.LOGGER.debug("Fixed slot " + i + " in " + String.valueOf(machineBase));
                this.updateSlotDetails(new SlotConfigHolder(i));
            }
        }
        if (!machineBase.method_10997().method_8608() && machineBase.method_10997().method_8510() % (long)machineBase.slotTransferSpeed() == 0L) {
            this.getSlotDetails().forEach(slotConfigHolder -> slotConfigHolder.handleItemIO(machineBase));
        }
    }

    public SlotConfiguration(class_11368 view) {
        this.read(view);
    }

    public List<SlotConfigHolder> getSlotDetails() {
        return this.slotDetails;
    }

    public SlotConfigHolder updateSlotDetails(SlotConfigHolder slotConfigHolder) {
        SlotConfigHolder lookup = this.getSlotDetails(slotConfigHolder.slotID);
        if (lookup != null) {
            this.slotDetails.remove(lookup);
        }
        this.slotDetails.add(slotConfigHolder);
        return slotConfigHolder;
    }

    @Nullable
    public SlotConfigHolder getSlotDetails(int id) {
        for (SlotConfigHolder detail : this.slotDetails) {
            if (detail.slotID != id) continue;
            return detail;
        }
        return null;
    }

    public List<SlotConfig> getSlotsForSide(class_2350 facing) {
        return this.slotDetails.stream().map(slotConfigHolder -> slotConfigHolder.getSideDetail(facing)).collect(Collectors.toList());
    }

    @Override
    public void write(class_11372 view) {
        view.method_71465("size", this.slotDetails.size());
        for (int i = 0; i < this.slotDetails.size(); ++i) {
            this.slotDetails.get(i).write(view.method_71461("slot_" + i));
        }
    }

    @Override
    public void read(class_11368 view) {
        int size = view.method_71424("size", 0);
        for (int i = 0; i < size; ++i) {
            view.method_71420("slot_" + i).ifPresent(slot -> this.updateSlotDetails(new SlotConfigHolder((class_11368)slot)));
        }
    }

    public String toJson(String machineIdent, class_7225.class_7874 registryLookup) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "SlotConfiguration", RebornCore.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registryLookup);
            this.write(view.method_71461("data"));
            view.method_71469("machine", machineIdent);
            String string = view.method_71475().toString();
            return string;
        }
    }

    public void readJson(String json, String machineIdent, class_7225.class_7874 registryLookup) throws UnsupportedOperationException {
        class_2487 compound;
        try {
            compound = class_2522.method_67315((String)json);
        }
        catch (CommandSyntaxException e) {
            throw new UnsupportedOperationException("Clipboard contents isn't a valid slot configuration");
        }
        if (!compound.method_10545("machine") || !((String)compound.method_10558("machine").orElseThrow()).equals(machineIdent)) {
            throw new UnsupportedOperationException("Machine config is not for this machine.");
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "SlotConfiguration", RebornCore.LOGGER);){
            this.read(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryLookup, (class_2487)compound.method_68568("data")));
        }
    }

    public static boolean canInsertItem(int index, class_1799 itemStackIn, class_2350 direction, MachineBaseBlockEntity blockEntity) {
        if (itemStackIn.method_7960()) {
            return false;
        }
        SlotConfigHolder slotConfigHolder = blockEntity.getSlotConfiguration().getSlotDetails(index);
        SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        if (slotConfig.getSlotIO().getIoConfig().isInsert()) {
            if (slotConfigHolder.filter() && blockEntity instanceof SlotFilter) {
                return ((SlotFilter)((Object)blockEntity)).isStackValid(index, itemStackIn);
            }
            return blockEntity.method_5437(index, itemStackIn);
        }
        return false;
    }

    public static boolean canExtractItem(int index, class_1799 stack, class_2350 direction, MachineBaseBlockEntity blockEntity) {
        SlotConfigHolder slotConfigHolder = blockEntity.getSlotConfiguration().getSlotDetails(index);
        SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        return slotConfig.getSlotIO().getIoConfig().isExtract();
    }

    public static class SlotConfigHolder
    implements NBTSerializable {
        public static final class_9139<ByteBuf, SlotConfigHolder> PACKET_CODEC = class_9139.method_58025((class_9139)class_9135.field_49675, SlotConfigHolder::getSlotID, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_2350.field_48450, SlotConfig.PACKET_CODEC), SlotConfigHolder::getSideMap, (class_9139)class_9135.field_48547, SlotConfigHolder::autoInput, (class_9139)class_9135.field_48547, SlotConfigHolder::autoOutput, (class_9139)class_9135.field_48547, SlotConfigHolder::filter, (class_9139)class_9135.field_49675, SlotConfigHolder::getPriority, SlotConfigHolder::new);
        int slotID;
        HashMap<class_2350, SlotConfig> sideMap;
        boolean input;
        boolean output;
        boolean filter;
        @Nullable
        public class_2350 first;
        @Nullable
        public class_2350 last;

        private SlotConfigHolder(int slotID, HashMap<class_2350, SlotConfig> sideMap, boolean input, boolean output, boolean filter, int priority) {
            this.slotID = slotID;
            this.sideMap = sideMap;
            this.input = input;
            this.output = output;
            this.filter = filter;
            this.setPriority(priority);
        }

        public SlotConfigHolder(int slotID) {
            this.slotID = slotID;
            this.sideMap = new HashMap();
            Arrays.stream(class_2350.values()).forEach(facing -> this.sideMap.put((class_2350)facing, new SlotConfig((class_2350)facing, slotID)));
        }

        public SlotConfigHolder(class_11368 view) {
            this.sideMap = new HashMap();
            this.read(view);
            Validate.isTrue((boolean)Arrays.stream(class_2350.values()).map(enumFacing -> this.sideMap.get(enumFacing)).noneMatch(Objects::isNull), (String)"sideMap failed to load from nbt", (Object[])new Object[0]);
        }

        public SlotConfig getSideDetail(class_2350 side) {
            Validate.notNull((Object)side, (String)"A none null side must be used", (Object[])new Object[0]);
            SlotConfig slotConfig = this.sideMap.get(side);
            Validate.notNull((Object)slotConfig, (String)("slotConfig was null for side " + String.valueOf(side)), (Object[])new Object[0]);
            return slotConfig;
        }

        public void updateSlotConfig(SlotConfig config) {
            SlotConfig toEdit = this.sideMap.get(config.side);
            toEdit.slotIO = config.slotIO;
        }

        private void handleItemIO(MachineBaseBlockEntity machineBase) {
            if (!this.input && !this.output) {
                return;
            }
            if (this.first != null) {
                this.handleItemSideIo(machineBase, this.sideMap.get(this.first));
            }
            this.sideMap.forEach((key, config) -> {
                if (key == this.first || key == this.last) {
                    return;
                }
                this.handleItemSideIo(machineBase, (SlotConfig)config);
            });
            if (this.last != null) {
                this.handleItemSideIo(machineBase, this.sideMap.get(this.last));
            }
        }

        private void handleItemSideIo(MachineBaseBlockEntity machineBase, SlotConfig config) {
            switch (config.getSlotIO().getIoConfig().ordinal()) {
                case 1: {
                    if (!this.input) break;
                    config.handleItemInput(machineBase);
                    break;
                }
                case 2: {
                    if (!this.output) break;
                    config.handleItemOutput(machineBase);
                }
            }
        }

        public boolean autoInput() {
            return this.input;
        }

        public boolean autoOutput() {
            return this.output;
        }

        public boolean filter() {
            return this.filter;
        }

        public int getPriority() {
            int first = this.first == null ? 6 : this.first.ordinal();
            int last = this.last == null ? 6 : this.last.ordinal();
            return first * 10 + last;
        }

        public void setPriority(int priority) {
            int first = priority / 10;
            int last = priority % 10;
            class_2350[] directions = class_2350.values();
            this.first = first == 6 ? null : directions[first];
            this.last = last == 6 ? null : directions[last];
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public void setFilter(boolean filter) {
            this.filter = filter;
        }

        public int getSlotID() {
            return this.slotID;
        }

        public HashMap<class_2350, SlotConfig> getSideMap() {
            return this.sideMap;
        }

        @Override
        public void write(class_11372 view) {
            view.method_71465("slotID", this.slotID);
            Arrays.stream(class_2350.values()).forEach(facing -> this.sideMap.get(facing).write(view.method_71461("side_" + facing.ordinal())));
            view.method_71472("input", this.input);
            view.method_71472("output", this.output);
            view.method_71472("filter", this.filter);
            if (this.first != null || this.last != null) {
                view.method_71465("priority", this.getPriority());
            }
        }

        @Override
        public void read(class_11368 view) {
            this.sideMap.clear();
            this.slotID = view.method_71424("slotID", 0);
            Arrays.stream(class_2350.values()).forEach(facing -> view.method_71420("side_" + facing.ordinal()).ifPresent(config -> this.sideMap.put((class_2350)facing, new SlotConfig((class_11368)config))));
            this.input = view.method_71433("input", false);
            this.output = view.method_71433("output", false);
            this.filter = view.method_71433("filter", false);
            view.method_71439("priority").ifPresentOrElse(this::setPriority, () -> {
                this.first = null;
                this.last = null;
            });
        }
    }

    public static class SlotConfig
    implements NBTSerializable {
        public static final class_9139<ByteBuf, SlotConfig> PACKET_CODEC = class_9139.method_56436((class_9139)class_2350.field_48450, SlotConfig::getSide, SlotIO.PACKET_CODEC, SlotConfig::getSlotIO, (class_9139)class_9135.field_49675, SlotConfig::getSlotID, SlotConfig::new);
        private class_2350 side;
        private SlotIO slotIO;
        private int slotID;

        public SlotConfig(class_2350 side, int slotID) {
            this.side = side;
            this.slotID = slotID;
            this.slotIO = new SlotIO(ExtractConfig.NONE);
        }

        public SlotConfig(class_2350 side, SlotIO slotIO, int slotID) {
            this.side = side;
            this.slotIO = slotIO;
            this.slotID = slotID;
        }

        public SlotConfig(class_11368 view) {
            this.read(view);
            Validate.notNull((Object)this.side, (String)"error when loading slot config", (Object[])new Object[0]);
            Validate.notNull((Object)this.slotIO, (String)"error when loading slot config", (Object[])new Object[0]);
        }

        public class_2350 getSide() {
            Validate.notNull((Object)this.side, (String)"side is null", (Object[])new Object[0]);
            return this.side;
        }

        public SlotIO getSlotIO() {
            Validate.notNull((Object)this.slotIO, (String)"error when loading slot config", (Object[])new Object[0]);
            return this.slotIO;
        }

        public int getSlotID() {
            return this.slotID;
        }

        private void handleItemInput(MachineBaseBlockEntity machineBase) {
            RebornInventory<?> inventory = machineBase.getOptionalInventory().get();
            class_1799 targetStack = inventory.method_5438(this.slotID);
            if (targetStack.method_7914() == targetStack.method_7947()) {
                return;
            }
            StorageUtil.move((Storage)((Storage)ItemStorage.SIDED.find(machineBase.method_10997(), machineBase.method_11016().method_10093(this.side), (Object)this.side.method_10153())), (Storage)InventoryStorage.of((class_1263)machineBase, null).getSlot(this.slotID), iv -> true, (long)4L, null);
        }

        private void handleItemOutput(MachineBaseBlockEntity machineBase) {
            RebornInventory<?> inventory = machineBase.getOptionalInventory().get();
            class_1799 sourceStack = inventory.method_5438(this.slotID);
            if (sourceStack.method_7960()) {
                return;
            }
            StorageUtil.move((Storage)InventoryStorage.of((class_1263)machineBase, null).getSlot(this.slotID), (Storage)((Storage)ItemStorage.SIDED.find(machineBase.method_10997(), machineBase.method_11016().method_10093(this.side), (Object)this.side.method_10153())), iv -> true, (long)Long.MAX_VALUE, null);
        }

        @Override
        public void write(class_11372 view) {
            view.method_71465("side", this.side.ordinal());
            this.slotIO.write(view.method_71461("config"));
            view.method_71465("slot", this.slotID);
        }

        @Override
        public void read(class_11368 view) {
            this.side = class_2350.values()[view.method_71424("side", 0)];
            view.method_71420("config").ifPresent(config -> {
                this.slotIO = new SlotIO((class_11368)config);
            });
            this.slotID = view.method_71424("slot", 0);
        }
    }

    public static class SlotIO
    implements NBTSerializable {
        public static final class_9139<ByteBuf, SlotIO> PACKET_CODEC = class_9139.method_56434(ExtractConfig.PACKET_CODEC, SlotIO::getIoConfig, SlotIO::new);
        ExtractConfig ioConfig;

        public SlotIO(class_11368 view) {
            this.read(view);
        }

        public SlotIO(ExtractConfig ioConfig) {
            this.ioConfig = ioConfig;
        }

        public ExtractConfig getIoConfig() {
            return this.ioConfig;
        }

        @Override
        public void write(class_11372 view) {
            view.method_71465("config", this.ioConfig.ordinal());
        }

        @Override
        public void read(class_11368 view) {
            this.ioConfig = ExtractConfig.values()[view.method_71424("config", 0)];
        }
    }

    public static enum ExtractConfig {
        NONE(false, false),
        INPUT(false, true),
        OUTPUT(true, false);

        public static final class_9139<ByteBuf, ExtractConfig> PACKET_CODEC;
        boolean extract;
        boolean insert;

        private ExtractConfig(boolean extract, boolean insert) {
            this.extract = extract;
            this.insert = insert;
        }

        public boolean isExtract() {
            return this.extract;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public ExtractConfig getNext() {
            int i = this.ordinal() + 1;
            if (i >= ExtractConfig.values().length) {
                i = 0;
            }
            return ExtractConfig.values()[i];
        }

        static {
            PACKET_CODEC = class_9135.field_49675.method_56432(integer -> ExtractConfig.values()[integer], Enum::ordinal);
        }
    }

    public static interface SlotFilter {
        public boolean isStackValid(int var1, class_1799 var2);

        public int[] getInputSlots();
    }
}

