/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.multiblock;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.client.multiblock.HologramRenderState;
import reborncore.client.multiblock.HologramRenderer;
import reborncore.common.blockentity.MachineBaseBlockEntity;

@Environment(value=EnvType.CLIENT)
public class MultiblockRenderer<T extends MachineBaseBlockEntity>
implements class_827<T, MultiblockRenderState> {
    private final class_776 blockRenderDispatcher;
    private final class_10442 itemModelResolver;

    public MultiblockRenderer(class_5614.class_5615 ctx) {
        this.blockRenderDispatcher = ctx.comp_4535();
        this.itemModelResolver = ctx.comp_4536();
    }

    @NotNull
    public MultiblockRenderState createRenderState() {
        return new MultiblockRenderState();
    }

    public void extractRenderState(T blockEntity, MultiblockRenderState state, float f, class_243 vec3, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_11954.method_74399(blockEntity, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        if (((MachineBaseBlockEntity)blockEntity).renderMultiblock && !((MachineBaseBlockEntity)blockEntity).isShapeValid()) {
            ArrayList<HologramRenderState> states = new ArrayList<HologramRenderState>();
            class_2350 direction = ((MachineBaseBlockEntity)blockEntity).getFacing().method_10153();
            ((MachineBaseBlockEntity)blockEntity).writeMultiblock(new HologramRenderer(this.blockRenderDispatcher, this.itemModelResolver, blockEntity.method_10997(), states).rotate(direction));
            if (states.isEmpty()) {
                return;
            }
            state.states = states;
        }
    }

    public void submit(MultiblockRenderState state, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (state.states != null) {
            for (HologramRenderState hologram : state.states) {
                hologram.submit(poseStack, submitNodeCollector, 0.4f);
            }
        }
    }

    public boolean method_3563() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class MultiblockRenderState
    extends class_11954 {
        List<HologramRenderState> states;
    }
}

