/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.element;

import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.minecraft.class_10799;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import org.joml.Matrix3x2f;
import org.joml.Quaternionfc;
import reborncore.client.gui.element.MachineFaceState;

@Environment(value=EnvType.CLIENT)
public class MachineFaceElementRenderer
extends class_11239<MachineFaceState> {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private static final RenderHandler renderHandler = new RenderHandler();
    private static final RenderElementHandler elementHandler = new RenderElementHandler();
    public static final List<class_2960> BLACKLIST = new ArrayList<class_2960>();

    public MachineFaceElementRenderer(SpecialGuiElementRegistry.Context context) {
        super(context.vertexConsumers());
    }

    public Class<MachineFaceState> method_70903() {
        return MachineFaceState.class;
    }

    protected String method_70906() {
        return "machine face";
    }

    protected void renderToTexture(MachineFaceState state, class_4587 matrices) {
        renderHandler.update(state, matrices, this.field_59933);
        renderHandler.render(2.0f, 0.0f, (Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        renderHandler.render(1.0f, 0.0f, (Quaternionfc)class_7833.field_40713.rotationDegrees(90.0f));
        renderHandler.render();
        renderHandler.render(-1.0f, 1.0f, (Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        renderHandler.render(-2.0f, 0.0f, (Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        renderHandler.render(-2.0f, 0.0f, (Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        renderHandler.clear();
    }

    protected void blitTexture(MachineFaceState element, class_11246 state) {
        elementHandler.update(element, state, this.field_60572);
        elementHandler.render(4, 23);
        elementHandler.render(23, 4);
        elementHandler.render(23, 23);
        elementHandler.render(23, 42);
        elementHandler.render(42, 23);
        elementHandler.render(42, 42);
        elementHandler.clear();
    }

    @Environment(value=EnvType.CLIENT)
    static class RenderHandler {
        private class_4588 vertexConsumer;
        private class_1087 model;
        private class_4587.class_4665 source;
        private int light;

        RenderHandler() {
        }

        public void clear() {
            this.vertexConsumer = null;
            this.model = null;
            this.source = null;
            this.light = 0;
        }

        public void render(float x, float y, Quaternionfc quaternionfc) {
            class_4587.class_4665 entry = this.source.method_56822();
            entry.method_67796(x, y, 0.0f);
            entry.method_67798(quaternionfc);
            this.render(entry);
        }

        public void render() {
            this.render(this.source);
        }

        private void render(class_4587.class_4665 entry) {
            for (class_10889 blockModelPart : this.model.method_68512(class_5819.method_43049((long)42L))) {
                for (class_2350 direction : DIRECTIONS) {
                    this.renderQuads(entry, blockModelPart.method_68509(direction));
                }
                this.renderQuads(entry, blockModelPart.method_68509(null));
            }
        }

        private void renderQuads(class_4587.class_4665 entry, List<class_777> bakedQuads) {
            for (class_777 bakedQuad : bakedQuads) {
                if (BLACKLIST.contains(bakedQuad.comp_3724().method_45851().method_45816())) continue;
                this.vertexConsumer.method_22919(entry, bakedQuad, 1.0f, 1.0f, 1.0f, 1.0f, this.light, class_4608.field_21444);
            }
        }

        public void update(MachineFaceState state, class_4587 matrices, class_4597.class_4598 vertexConsumers) {
            this.vertexConsumer = vertexConsumers.method_73477(class_1921.method_23577());
            this.model = state.model();
            this.light = class_4608.method_23210((float)15.0f);
            this.source = matrices.method_23760();
            this.source.method_67800(-16.0f, -16.0f, 0.0f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class RenderElementHandler {
        private class_11246 state;
        private class_11231 texture;
        private Matrix3x2f pose;
        private int x1;
        private int y1;
        private int i;

        RenderElementHandler() {
        }

        public void clear() {
            this.state = null;
            this.texture = null;
            this.pose = null;
            this.x1 = 0;
            this.y1 = 0;
            this.i = -1;
        }

        public void render(int x, int y) {
            ++this.i;
            int left = this.x1 + x;
            int top = this.y1 + y;
            float u1 = (float)this.i / 6.0f;
            float u2 = (float)(this.i + 1) / 6.0f;
            this.state.method_71996(new class_11241(class_10799.field_59968, this.texture, this.pose, left, top, left + 16, top + 16, u1, u2, 1.0f, 0.0f, -1, null, null));
        }

        public void update(MachineFaceState element, class_11246 guiRenderState, GpuTextureView textureView) {
            this.state = guiRenderState;
            this.texture = class_11231.method_70900((GpuTextureView)textureView);
            this.pose = element.method_72127();
            this.x1 = element.comp_4122();
            this.y1 = element.comp_4123();
            this.i = -1;
        }
    }
}

