/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.config.elements.ButtonElement;
import reborncore.client.gui.config.elements.CheckBoxElement;
import reborncore.client.gui.config.elements.ParentElement;
import reborncore.client.gui.config.elements.SlotConfigPopupElement;
import reborncore.client.gui.config.elements.SlotType;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.screen.slot.BaseSlot;

@Environment(value=EnvType.CLIENT)
public class ConfigSlotElement
extends ParentElement {
    private final SlotType type;
    private final class_1263 inventory;
    private final int id;
    private final int height;

    public ConfigSlotElement(class_1263 slotInventory, BaseSlot slot, SlotType type, int x, int y, GuiBase<?> gui, Runnable closeConfig) {
        super(x, y, type.getButtonSprite(), type.getTextureWidth(), type.getTextureHeight());
        SlotConfiguration.SlotFilter slotFilter;
        this.type = type;
        this.inventory = slotInventory;
        this.id = slot.method_34266();
        boolean inputEnabled = slot.canWorldBlockInsert();
        MachineBaseBlockEntity machineBaseBlockEntity = gui.getMachine();
        boolean filterEnabled = machineBaseBlockEntity instanceof SlotConfiguration.SlotFilter && Arrays.stream((slotFilter = (SlotConfiguration.SlotFilter)((Object)machineBaseBlockEntity)).getInputSlots()).anyMatch(value -> value == this.id);
        this.height = 107 + (inputEnabled ? 15 : 0) + (filterEnabled ? 15 : 0);
        SlotConfigPopupElement popupElement = new SlotConfigPopupElement(this.id, x - 22, y - 22, this.height, inputEnabled);
        this.elements.add(popupElement);
        this.elements.add(new ButtonElement(x + 37, y - 25, GuiSprites.EXIT_BUTTON, 13, 13, closeConfig));
        int checkboxY = y + 44;
        if (inputEnabled) {
            this.elements.add(new CheckBoxElement((class_2561)class_2561.method_43471((String)"reborncore.gui.slotconfig.autoinput"), x - 26, checkboxY += 15, checkBoxElement -> gui.getMachine().getSlotConfiguration().getSlotDetails(this.id).autoInput(), () -> popupElement.updateCheckBox("input", gui)));
        }
        this.elements.add(new CheckBoxElement((class_2561)class_2561.method_43471((String)"reborncore.gui.slotconfig.autooutput"), x - 26, checkboxY += 15, checkBoxElement -> gui.getMachine().getSlotConfiguration().getSlotDetails(this.id).autoOutput(), () -> popupElement.updateCheckBox("output", gui)));
        if (filterEnabled) {
            this.elements.add(new CheckBoxElement((class_2561)class_2561.method_43471((String)"reborncore.gui.slotconfig.filter_input"), x - 26, checkboxY + 15, checkBoxElement -> gui.getMachine().getSlotConfiguration().getSlotDetails(this.id).filter(), () -> popupElement.updateCheckBox("filter", gui)));
        }
    }

    @Override
    public int getWidth() {
        return 85;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
        class_1799 stack = this.inventory.method_5438(this.id);
        int xPos = this.getX() + 1 + gui.getGuiLeft();
        int yPos = this.getY() + 1 + gui.getGuiTop();
        drawContext.method_51427(stack, xPos, yPos);
        if (this.isMouseWithinRect(gui, mouseX, mouseY)) {
            this.drawSprite(drawContext, gui, this.type.getButtonHoverOverlay(), this.getX(), this.getY(), this.type.getTextureWidth(), this.type.getTextureHeight());
        }
        super.draw(drawContext, gui, mouseX, mouseY);
    }

    public int getId() {
        return this.id;
    }
}

