/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4730;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.config.elements.ElementBase;

@Environment(value=EnvType.CLIENT)
public class CheckBoxElement
extends ElementBase {
    private final class_2561 label;
    private final Predicate<CheckBoxElement> ticked;
    private final Runnable onChange;
    private final GuiSprites.CheckBox checkBoxSprite = GuiSprites.LIGHT_CHECK_BOX;

    public CheckBoxElement(class_2561 label, int x, int y, Predicate<CheckBoxElement> ticked, Runnable onChange) {
        super(x, y, GuiSprites.LIGHT_CHECK_BOX.normal(), 13, 13);
        this.label = label;
        this.ticked = ticked;
        this.onChange = onChange;
        this.updateSprites();
    }

    private void updateSprites() {
        if (this.ticked.test(this)) {
            this.setSprite(this.checkBoxSprite.ticked());
        } else {
            this.setSprite(this.checkBoxSprite.normal());
        }
    }

    @Override
    public boolean onClick(GuiBase<?> gui, double mouseX, double mouseY) {
        this.onChange.run();
        this.updateSprites();
        return true;
    }

    @Override
    public void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
        class_4730 sprite = this.checkBoxSprite.normal();
        int textureWidth = this.getWidth();
        int textureHeight = this.getHeight();
        if (this.ticked.test(this)) {
            textureWidth = 16;
            sprite = this.checkBoxSprite.ticked();
        }
        this.drawSprite(drawContext, gui, sprite, this.getX(), this.getY(), textureWidth, textureHeight);
        int n = this.getX() + 18;
        int n2 = this.getY() + this.getHeight() / 2;
        Objects.requireNonNull(gui.method_64506());
        this.drawText(drawContext, gui, this.label, n, n2 - 9 / 2, -1);
    }
}

