/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_11256;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_776;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.config.elements.ElementBase;
import reborncore.client.gui.element.MachineFaceState;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.MachineFacing;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractConfigPopupElement
extends ElementBase {
    private final int height;
    private final String[] pencils;
    private int pencilWidth;
    private int fixIndex = Integer.MAX_VALUE;
    private boolean mouseDown = false;
    private final boolean[] mouseIn = new boolean[]{false, false, false, false, false, false};
    private final MachineFacing[] mouseBoxFacingMap = new MachineFacing[]{MachineFacing.UP, MachineFacing.FRONT, MachineFacing.RIGHT, MachineFacing.LEFT, MachineFacing.DOWN, MachineFacing.BACK};
    private final int[][] mouseBoxMap = new int[][]{{23, 4}, {23, 23}, {42, 23}, {4, 23}, {23, 42}, {42, 42}};
    @Nullable
    public String pencil;

    public AbstractConfigPopupElement(int x, int y, int height, class_4730 sprite, int textureWidth, int textureHeight, String[] pencils) {
        super(x, y, sprite, textureWidth, textureHeight);
        this.height = height;
        this.pencils = pencils;
        int space = 75 - pencils.length;
        this.pencilWidth = space / pencils.length;
        if (space % this.pencilWidth != 0) {
            ++this.pencilWidth;
            this.fixIndex = space % pencils.length;
        }
    }

    @Override
    public boolean isMouseWithinRect(GuiBase<?> gui, double mouseX, double mouseY) {
        return AbstractConfigPopupElement.isInRect(gui, this.getX() - 8, this.getY(), 84, 79, mouseX, mouseY);
    }

    @Override
    public final void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
        drawContext.method_51448().pushMatrix();
        int x = this.adjustX(gui, this.getX() - 8);
        int y = this.adjustY(gui, this.getY() - 7);
        gui.builder.drawDefaultBackground(drawContext, x, y, 84, this.height);
        drawContext.method_51448().popMatrix();
        super.draw(drawContext, gui, mouseX, mouseY);
        class_310 client = class_310.method_1551();
        MachineBaseBlockEntity machine = (MachineBaseBlockEntity)gui.be;
        class_2680 state = machine.method_11010();
        class_2680 defaultState = state.method_26204().method_9564();
        class_776 dispatcher = client.method_1541();
        class_1087 model = dispatcher.method_3351().method_3335(defaultState);
        drawContext.field_59826.method_70922((class_11256)new MachineFaceState(new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), model, gui.getGuiLeft() + this.getX(), gui.getGuiTop() + this.getY()));
        if (this.mouseDown) {
            for (int i = 0; i < 6; ++i) {
                if (!this.isInBox(this.mouseBoxMap[i][0], this.mouseBoxMap[i][1], 16, 16, mouseX, mouseY, gui)) continue;
                if (this.mouseIn[i]) break;
                this.mouseIn[i] = true;
                this.cycleConfig(this.mouseBoxFacingMap[i].getFacing(gui.getMachine()), gui);
                break;
            }
        }
        this.drawSateColor(drawContext, gui, MachineFacing.UP.getFacing(machine), 22, -1);
        this.drawSateColor(drawContext, gui, MachineFacing.FRONT.getFacing(machine), 22, 18);
        this.drawSateColor(drawContext, gui, MachineFacing.DOWN.getFacing(machine), 22, 37);
        this.drawSateColor(drawContext, gui, MachineFacing.RIGHT.getFacing(machine), 41, 18);
        this.drawSateColor(drawContext, gui, MachineFacing.BACK.getFacing(machine), 41, 37);
        this.drawSateColor(drawContext, gui, MachineFacing.LEFT.getFacing(machine), 3, 18);
        this.drawPencil(drawContext, gui, mouseX, mouseY, x, y + 71);
    }

    @Override
    public final boolean onClick(GuiBase<?> gui, double mouseX, double mouseY) {
        this.mouseDown = true;
        for (int i = 0; i < 6; ++i) {
            if (!this.isInBox(this.mouseBoxMap[i][0], this.mouseBoxMap[i][1], 16, 16, mouseX, mouseY, gui)) continue;
            this.mouseIn[i] = true;
            this.cycleConfig(this.mouseBoxFacingMap[i].getFacing(gui.getMachine()), gui);
            return true;
        }
        int rectX = -2;
        int rectWidth = this.pencilWidth - 2;
        for (String pencil : this.pencils) {
            if (this.isInBox(rectX, 65, rectWidth, 11, mouseX, mouseY, gui)) {
                this.pencil = pencil.equals(this.pencil) ? null : pencil;
                return true;
            }
            rectX += this.pencilWidth + 1;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        this.mouseDown = false;
        Arrays.fill(this.mouseIn, false);
        return true;
    }

    protected abstract void cycleConfig(class_2350 var1, GuiBase<?> var2);

    protected abstract void drawSateColor(class_332 var1, GuiBase<?> var2, class_2350 var3, int var4, int var5);

    protected boolean isInBox(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY, GuiBase<?> guiBase) {
        return AbstractConfigPopupElement.isInRect(guiBase, rectX += this.getX(), rectY += this.getY(), rectWidth, rectHeight, pointX, pointY);
    }

    protected abstract int getPencilColor(String var1);

    protected void drawPencil(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY, int x, int y) {
        int mx = mouseX - gui.getGuiLeft();
        int my = mouseY - gui.getGuiTop();
        x += 5;
        int y2 = y + 13;
        int y3 = y + 3;
        class_327 textRenderer = gui.method_64506();
        int len = this.pencils.length;
        for (int i = 0; i < len; ++i) {
            int color;
            String pencil = this.pencils[i];
            int x2 = x + (i >= this.fixIndex ? this.pencilWidth - 1 : this.pencilWidth);
            if (pencil.equals(this.pencil)) {
                color = this.getPencilColor(pencil);
            } else if (mx >= x && mx <= x2 && my >= y && my < y2) {
                drawContext.method_51438(textRenderer, (class_2561)class_2561.method_43471((String)("reborncore.gui.slotconfig." + pencil)), mouseX, mouseY + 10);
                color = mx != x2 ? -7631989 : 0x668B8B8B;
            } else {
                color = 0x668B8B8B;
            }
            drawContext.method_25294(x, y, x2, y2, color);
            class_2561 letter = class_2561.method_30163((String)pencil.substring(0, 1));
            int x3 = x + (this.pencilWidth - textRenderer.method_27525((class_5348)letter)) / 2;
            drawContext.method_51439(textRenderer, letter, x3, y3, -1, false);
            x = x2 + 1;
        }
    }
}

