/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_10444;
import net.minecraft.class_11278;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_11684;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9779;
import org.joml.Matrix4fStack;
import reborncore.client.ItemStackRenderManager;

@Environment(value=EnvType.CLIENT)
public class ItemStackRenderer
implements HudRenderCallback {
    private static class_11278 guiProjectionMatrix;
    private static final int SIZE = 512;

    public void onHudRender(class_332 drawContext, class_9779 tickCounter) {
        if (!ItemStackRenderManager.RENDER_QUEUE.isEmpty()) {
            if (guiProjectionMatrix == null) {
                guiProjectionMatrix = new class_11278("gui", 1000.0f, 11000.0f, true);
            }
            class_1799 itemStack = ItemStackRenderManager.RENDER_QUEUE.remove();
            this.export(drawContext, itemStack, ItemStackRenderManager.RENDER_QUEUE.size());
        }
    }

    private void export(class_332 drawContext, class_1799 stack, int queue) {
        class_310 client = class_310.method_1551();
        class_276 framebuffer = client.method_1522();
        GpuTexture gpuTexture = framebuffer.method_30277();
        if (gpuTexture == null) {
            return;
        }
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(gpuTexture, 0, framebuffer.method_30278(), 1.0);
        class_1041 window = client.method_22683();
        float scaleFactor = window.method_4495();
        int drawSize = Math.min(framebuffer.field_1481, 512);
        int left = (int)((float)drawSize / scaleFactor) + 5;
        class_2960 identifier = class_7923.field_41178.method_10221((Object)stack.method_7909());
        drawContext.method_51433(client.field_1772, "Rendering " + String.valueOf(identifier), left, 5, -1, false);
        drawContext.method_51433(client.field_1772, queue + " items left", left, 15, -1, false);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)guiProjectionMatrix.method_71092((float)window.method_4489() / scaleFactor, (float)window.method_4506() / scaleFactor), (class_10366)class_10366.field_54954);
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.translate(0.0f, 0.0f, -11000.0f);
        class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        float drawScale = (float)drawSize / (16.0f * scaleFactor);
        matrices.method_22905(drawScale, drawScale, drawScale);
        class_10444 itemRenderState = new class_10444();
        client.method_65386().method_65598(itemRenderState, stack, class_811.field_4317, (class_1937)client.field_1687, (class_11566)client.field_1724, 0);
        matrices.method_46416(8.0f, 8.0f, 150.0f);
        matrices.method_22905(16.0f, -16.0f, 16.0f);
        boolean bl = !itemRenderState.method_65608();
        class_757 gameRenderer = class_310.method_1551().field_1773;
        class_308 diffuseLighting = gameRenderer.method_71114();
        if (bl) {
            diffuseLighting.method_71034(class_308.class_11274.field_60026);
        } else {
            diffuseLighting.method_71034(class_308.class_11274.field_60027);
        }
        class_11684 renderDispatcher = gameRenderer.method_72911();
        itemRenderState.method_65604(matrices, (class_11659)renderDispatcher.method_73003(), 0xF000F0, class_4608.field_21444, 0);
        renderDispatcher.method_73002();
        vertexConsumers.method_22993();
        matrix4fStack.popMatrix();
        RenderSystem.restoreProjectionMatrix();
        int pixelSize = gpuTexture.getFormat().pixelSize();
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Export buffer", 9, framebuffer.field_1482 * framebuffer.field_1481 * pixelSize);
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        commandEncoder.copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
            try (GpuBuffer.MappedView readView = commandEncoder.mapBuffer(gpuBuffer, true, false);){
                ByteBuffer imageData = readView.data();
                class_1011 nativeImage = null;
                try {
                    int scale = drawSize < 512 ? 2 : 1;
                    int imageSize = drawSize * scale;
                    nativeImage = new class_1011(imageSize, imageSize, false);
                    int maxRowIndex = imageSize - 1;
                    for (int rowIndex = 0; rowIndex < drawSize; ++rowIndex) {
                        int scaledRowIndex = rowIndex * scale;
                        for (int colIndex = 0; colIndex < drawSize; ++colIndex) {
                            int scaledColIndex = colIndex * scale;
                            int color = imageData.getInt((colIndex + rowIndex * drawSize) * pixelSize);
                            for (int x = 0; x < scale; ++x) {
                                for (int y = 0; y < scale; ++y) {
                                    nativeImage.method_4305(scaledColIndex + x, maxRowIndex - scaledRowIndex - y, color);
                                }
                            }
                        }
                    }
                    if (drawSize < 512) {
                        class_1011 destroy = null;
                        try {
                            class_1011 resizedImage;
                            destroy = resizedImage = new class_1011(512, 512, false);
                            nativeImage.method_4300(0, 0, imageSize, imageSize, resizedImage);
                            destroy = nativeImage;
                            nativeImage = resizedImage;
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            if (destroy != null) {
                                try {
                                    destroy.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    Path path = FabricLoader.getInstance().getGameDir().resolve("item_renderer").resolve(identifier.method_12836()).resolve(identifier.method_12832() + ".png");
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    nativeImage.method_4314(path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            gpuBuffer.close();
        }, 0, 0, framebuffer.field_1481 - drawSize, drawSize, drawSize);
    }
}

