/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2024 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.mixin.common;

import net.minecraft.class_11897;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_5539;
import net.minecraft.class_6749;
import net.minecraft.world.level.chunk.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import reborncore.common.misc.world.ChunkEventListeners;

@Mixin(class_2818.class)
public abstract class WorldChunkMixin extends class_2791 {
	public WorldChunkMixin(class_1923 pos, class_2843 upgradeData, class_5539 heightLimitView, class_11897 palettedContainerFactory, long inhabitedTime,
						@Nullable class_2826[] sectionArrayInitializer, @Nullable class_6749 blendingData) {
		super(pos, upgradeData, heightLimitView, palettedContainerFactory, inhabitedTime, sectionArrayInitializer, blendingData);
		throw new AssertionError();
	}

	@Shadow
	@Final
	class_1937 level;

	@SuppressWarnings("rawtypes")
	@Inject(method = "setBlockState", at = @At("HEAD"))
	private void onSetBlockState(class_2338 pos, class_2680 state, int flags, CallbackInfoReturnable cir) {
		if (!level.method_8608()) {
			ChunkEventListeners.onBlockStateChange(level, this.field_34538, pos);
		}
	}
}
