/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.mixin.common;

import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.common.powerSystem.RcEnergyItem;

@Mixin(class_1657.class)
public abstract class MixinPlayerEntity extends class_1309 {
	protected MixinPlayerEntity(class_1299<? extends class_1309> type, class_1937 world) {
		super(type, world);
	}

	@Inject(method = "tick", at = @At("HEAD"))
	public void tick(CallbackInfo info) {
		class_1657 playerEntity = (class_1657) (Object) this;
		if (playerEntity.method_7325()) return;
		if (!playerEntity.field_7498.field_7827) {
			class_1799 stack = playerEntity.field_7498.method_34255();
			if (stack.method_7909() instanceof ArmorBlockEntityTicker ticker) {
				stack.method_57381(class_9334.field_49628);
				ticker.tickArmor(stack, false, playerEntity);
			}
			return;
		}

		Class<?> suit = null;
		int count = 0;
		for (class_1304 equipmentSlot : class_9274.field_49224) {
			if (equipmentSlot == class_1304.field_48824) continue;
			class_1799 stack = playerEntity.method_6118(equipmentSlot);
			if (!(stack.method_7909() instanceof RcEnergyItem item)) {
				break;
			}
			if (item.getStoredEnergy(stack) == 0) {
				break;
			}
			if (suit == null) {
				suit = item.getClass();
			} else if (suit != item.getClass()) {
				break;
			}
			count++;
		}

		for (class_1304 equipmentSlot : class_9274.field_49224) {
			if (equipmentSlot == class_1304.field_48824) continue;
			class_1799 stack = playerEntity.method_6118(equipmentSlot);
			if (stack.method_7909() instanceof ArmorBlockEntityTicker ticker) {
				// mark tick
				if (!stack.method_57826(class_9334.field_49628)) {
					stack.method_57379(class_9334.field_49628, class_9279.field_49302);
				}
				ticker.tickArmor(stack, count == 4, playerEntity);
			}
		}
	}
}
